/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.utils.item;

import java.util.List;
import lombok.Generated;
import nl.openminetopia.utils.VersionUtil;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class ItemUtils {
    public static void applyEffects(Player target, List<PotionEffect> effects, int duration) {
        for (PotionEffect effect : effects) {
            PotionEffect potionEffect = new PotionEffect(effect.getType(), duration, effect.getAmplifier());
            target.addPotionEffect(potionEffect);
        }
    }

    public static void clearEffects(Player target, List<PotionEffect> effects) {
        for (PotionEffect effect : effects) {
            PotionEffectType potionEffectType = effect.getType();
            target.getActivePotionEffects().forEach(activeEffect -> {
                if (activeEffect.getType().equals(potionEffectType)) {
                    target.removePotionEffect(potionEffectType);
                }
            });
        }
    }

    public static boolean isSimilarToAny(ItemStack itemToCheck, List<ItemStack> validItems) {
        if (itemToCheck == null || validItems == null || validItems.isEmpty()) {
            return false;
        }
        for (ItemStack item : validItems) {
            if (item == null || item.getType() != itemToCheck.getType()) continue;
            ItemMeta meta = item.getItemMeta();
            ItemMeta checkMeta = itemToCheck.getItemMeta();
            if (meta == null && checkMeta == null) {
                return true;
            }
            if (meta == null || checkMeta == null || meta.hasCustomModelData() != checkMeta.hasCustomModelData() || meta.hasCustomModelData() && meta.getCustomModelData() != checkMeta.getCustomModelData()) continue;
            if (meta instanceof Damageable) {
                Damageable damageMeta = (Damageable)meta;
                if (checkMeta instanceof Damageable) {
                    Damageable checkDamageMeta = (Damageable)checkMeta;
                    if (damageMeta.getDamage() != checkDamageMeta.getDamage()) continue;
                }
            }
            if (VersionUtil.isCompatible("1.21.4")) {
                NamespacedKey modelA = meta.getItemModel();
                NamespacedKey modelB = checkMeta.getItemModel();
                if (!(modelA == null && modelB == null || modelA != null && modelB != null && modelA.equals((Object)modelB))) continue;
            }
            return true;
        }
        return false;
    }

    @Generated
    private ItemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

