/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rumpnissar.client.renderer;

import net.mcreator.rumpnissar.client.model.Modelrumpnissar;
import net.mcreator.rumpnissar.client.model.animations.rumpnissarAnimation;
import net.mcreator.rumpnissar.entity.RumpnissarEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class RumpnissarRenderer
extends MobRenderer<RumpnissarEntity, LivingEntityRenderState, Modelrumpnissar> {
    private RumpnissarEntity entity = null;

    public RumpnissarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelrumpnissar.LAYER_LOCATION)), 0.4f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(RumpnissarEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        if (this.entity != null) {
            return ResourceLocation.parse((String)("rumpnissar:textures/entities/" + this.entity.getTexture() + ".png"));
        }
        return ResourceLocation.parse((String)"rumpnissar:textures/entities/rumpnissar.png");
    }

    private static final class AnimatedModel
    extends Modelrumpnissar {
        private RumpnissarEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(RumpnissarEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, rumpnissarAnimation.idle, state.ageInTicks, 1.0f);
            this.animateWalk(rumpnissarAnimation.walk, state.walkAnimationPos, state.walkAnimationSpeed, 1.5f, 5.0f);
            this.animate(this.entity.animationState2, rumpnissarAnimation.gifting, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

