/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class SmiteEntity
extends Entity {
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_BEAM_LENGTH = "MAHOUTSUKAI_BEAM_LENGTH";
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> BEAM_SIZE = SynchedEntityData.defineId(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.defineId(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> BEAM_LENGTH = SynchedEntityData.defineId(SmiteEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public Entity target;
    public float damage;
    public float prev_beam_len;
    public float prev_beam_size;
    public float maxlen = 250.0f;
    public int m;
    public static final String entityName = "smite_entity";

    public SmiteEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public SmiteEntity(Level world) {
        super((EntityType)ModEntities.SMITE.get(), world);
        this.noCulling = true;
    }

    public SmiteEntity(Level world, LivingEntity target, float r, float g, float b, float a, float size, float damage) {
        this(world);
        this.setColor(r, g, b, a);
        this.sizer(size);
        this.target = target;
        this.damage = damage;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
        builder.define(DISTANCE, (Object)Float.valueOf(0.0f));
        builder.define(BEAM_LENGTH, (Object)Float.valueOf(0.0f));
    }

    public void tick() {
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (!this.level().isClientSide) {
            if (this.target == null) {
                this.discard();
                return;
            }
            this.setPos(this.target.getX(), this.target.getY(), this.target.getZ());
            if ((double)this.getBeamSize() < (double)this.target.getBbWidth() * 1.5) {
                this.setBeamSize(this.getBeamSize() + 0.1f);
            } else if (this.getBeamLength() < this.maxlen) {
                this.setBeamLength(this.getBeamLength() + 10.0f);
                if (this.getBeamLength() == this.maxlen - 10.0f) {
                    this.level().playSound(null, Utils.toBlockPos(this.position()), (SoundEvent)ModSounds.SMITE.get(), SoundSource.NEUTRAL, (float)MTConfig.SMITE_VOLUME, 1.0f);
                }
            } else {
                ++this.m;
                if (this.m > 5) {
                    EffectUtil.magicAttack((LivingEntity)this.target, this.damage, null);
                    this.discard();
                }
            }
        } else {
            float[] rgb = this.getColor();
            for (double i = (double)this.prev_beam_len; i < (double)this.getBeamLength(); i += 1.0) {
                MahouTsukaiMod.proxy.smiteParticles(this.getX(), this.getY() + (double)this.maxlen - i, this.getZ(), this.random, false, this.getBeamSize(), rgb[0], rgb[1], rgb[2]);
            }
            if (this.getBeamLength() == this.maxlen - 10.0f) {
                MahouTsukaiMod.proxy.smiteParticles(this.getX(), this.getY() + 0.5, this.getZ(), this.random, true, this.getBeamSize(), rgb[0], rgb[1], rgb[2]);
            }
        }
        this.prev_beam_len = this.getBeamLength();
        this.prev_beam_size = this.getBeamSize();
    }

    public boolean isPickable() {
        return false;
    }

    public void playerTouch(Player entityIn) {
    }

    public void setColor(float r, float g, float b, float a) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    protected void checkInsideBlocks() {
    }

    @Nullable
    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue()};
    }

    public void sizer(float s) {
        this.setBeamSize(s);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setBeamSize(compound.getFloat(TAG_BEAM_SIZE));
        this.setBeamLength(compound.getFloat(TAG_BEAM_LENGTH));
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A));
        this.setDistance(compound.getFloat(TAG_DISTANCE));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_BEAM_SIZE, this.getBeamSize());
        compound.putFloat(TAG_BEAM_LENGTH, this.getBeamLength());
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putFloat(TAG_DISTANCE, this.getDistance());
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public float getBeamSize() {
        return ((Float)this.entityData.get(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float s) {
        this.entityData.set(BEAM_SIZE, (Object)Float.valueOf(s));
    }

    public float getBeamLength() {
        return ((Float)this.entityData.get(BEAM_LENGTH)).floatValue();
    }

    public void setBeamLength(float s) {
        this.entityData.set(BEAM_LENGTH, (Object)Float.valueOf(s));
    }

    public float getDistance() {
        return ((Float)this.entityData.get(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.entityData.set(DISTANCE, (Object)Float.valueOf(d));
    }
}

