/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.mahoujin.BeamProjectileEntity;

public class MysticStaffAOEMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_SHOOTING_TICKS = "MAHOUTSUKAI_SHOOTING_TICKS";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A2 = "MAHOUTSUKAI_COLOR_A2";
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SHOOTING_TICKS = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A2 = SynchedEntityData.defineId(MysticStaffAOEMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public float startYaw = 0.0f;
    public float startPitch = 0.0f;
    public Vec3 startVelocity = new Vec3(0.0, 0.0, 0.0);
    public UUID casterUUID = null;
    public static final String entityName = "aoe_mahoujin_entity";

    public MysticStaffAOEMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public MysticStaffAOEMahoujinEntity(Level world) {
        super((EntityType)ModEntities.AOE_EXPLOSION_MAHOUJIN.get(), world);
        this.noCulling = true;
    }

    public MysticStaffAOEMahoujinEntity(Level world, Player caster) {
        this(world);
        this.casterUUID = caster.getUUID();
    }

    public MysticStaffAOEMahoujinEntity(Level world, Player caster, float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        this(world);
        this.startPitch = caster.xRot;
        this.startYaw = caster.yRot;
        this.startVelocity = caster.getViewVector(1.0f);
        this.casterUUID = caster.getUUID();
        this.setColor(r, g, b, a, r2, g2, b2, a2);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A2, (Object)Float.valueOf(1.0f));
        builder.define(SHOOTING_TICKS, (Object)-1);
        builder.define(DISTANCE, (Object)Float.valueOf(0.0f));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setLife(this.getLife() + 1);
            if (this.getLife() == 10) {
                float[] colors = this.getColor();
                BeamProjectileEntity bpe = new BeamProjectileEntity(this.level(), this.casterUUID, colors[0], colors[1], colors[2], 0.3f, colors[4], colors[5], colors[6], 1.0f, 0.15f, 0.0f);
                Vec3 v = this.startVelocity.normalize().scale(7.0);
                bpe.setDeltaMovement(v.x, v.y, v.z);
                bpe.setPos(this.getX(), this.getY(), this.getZ());
                bpe.setRotationYaw(180.0f - this.startYaw);
                bpe.setRotationPitch(90.0f - this.startPitch);
                this.level().addFreshEntity((Entity)bpe);
            }
            if (this.getLife() > 20) {
                this.discard();
            }
        }
    }

    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
        this.entityData.set(COLOR_R2, (Object)Float.valueOf(r2));
        this.entityData.set(COLOR_G2, (Object)Float.valueOf(g2));
        this.entityData.set(COLOR_B2, (Object)Float.valueOf(b2));
        this.entityData.set(COLOR_A2, (Object)Float.valueOf(a2));
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue(), ((Float)this.entityData.get(COLOR_R2)).floatValue(), ((Float)this.entityData.get(COLOR_G2)).floatValue(), ((Float)this.entityData.get(COLOR_B2)).floatValue(), ((Float)this.entityData.get(COLOR_A2)).floatValue()};
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public void setCasterUUID(UUID uuid) {
        this.casterUUID = uuid;
    }

    public void sizer(float f) {
        this.setCircleSize(f);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.getFloat("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setCircleSize(compound.getFloat("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setLife(compound.getInt(TAG_LIFE));
        this.casterUUID = compound.getUUID(TAG_CASTER);
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A), compound.getFloat(TAG_COLOR_R2), compound.getFloat(TAG_COLOR_G2), compound.getFloat(TAG_COLOR_B2), compound.getFloat(TAG_COLOR_A2));
        this.setShootingTicks(compound.getInt(TAG_SHOOTING_TICKS));
        this.setDistance(compound.getFloat(TAG_DISTANCE));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.putFloat("MAHOUTSUKAI_ROTATION_SPEED", this.getRotationSpeed());
        compound.putFloat("MAHOUTSUKAI_ROTATION_SPEED", this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putUUID(TAG_CASTER, this.casterUUID);
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putFloat(TAG_COLOR_R2, colors[4]);
        compound.putFloat(TAG_COLOR_G2, colors[5]);
        compound.putFloat(TAG_COLOR_B2, colors[6]);
        compound.putFloat(TAG_COLOR_A2, colors[7]);
        compound.putInt(TAG_SHOOTING_TICKS, this.getShootingTicks());
        compound.putFloat(TAG_DISTANCE, this.getDistance());
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        Vec3 Vec32 = new Vec3(p_70186_1_, p_70186_3_, p_70186_5_).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.random.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.random.nextGaussian() * (double)0.0075f * (double)p_70186_8_).scale((double)p_70186_7_);
        this.setDeltaMovement(Vec32);
        float f = Mth.sqrt((float)((float)Vec32.horizontalDistanceSqr()));
        this.yRot = (float)(Mth.atan2((double)Vec32.x, (double)Vec32.z) * 57.2957763671875);
        this.xRot = (float)(Mth.atan2((double)Vec32.y, (double)f) * 57.2957763671875);
        this.yRotO = this.yRot;
        this.xRotO = this.xRot;
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public int getShootingTicks() {
        return (Integer)this.entityData.get(SHOOTING_TICKS);
    }

    public void setShootingTicks(int t) {
        this.entityData.set(SHOOTING_TICKS, (Object)t);
    }

    public float getDistance() {
        return ((Float)this.entityData.get(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.entityData.set(DISTANCE, (Object)Float.valueOf(d));
    }
}

