/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import stepsword.mahoutsukai.dataattachments.worldsave.FictionData;
import stepsword.mahoutsukai.dataattachments.worldsave.MahouSavedData;
import stepsword.mahoutsukai.item.rulebreaker.ProbabilityAlterRandom;
import stepsword.mahoutsukai.item.william.EmeraldForFiction;
import stepsword.mahoutsukai.util.Utils;

@Mixin(value={AbstractVillager.class})
public class MixinAbstractVillager {
    @Inject(method={"addOffersFromItemListings(Lnet/minecraft/world/item/trading/MerchantOffers;[Lnet/minecraft/world/entity/npc/VillagerTrades$ItemListing;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void mahouRuleBreakerVillagerFix(MerchantOffers offers, VillagerTrades.ItemListing[] trades, int tradeCnt, CallbackInfo info) {
        AbstractVillager current = (AbstractVillager)this;
        RandomSource random = current.random;
        if (random instanceof ProbabilityAlterRandom) {
            ArrayList set = Lists.newArrayList();
            if (trades.length > tradeCnt) {
                while (set.size() < tradeCnt) {
                    set.add(random.nextInt(trades.length));
                }
            } else {
                for (int i = 0; i < trades.length; ++i) {
                    set.add(i);
                }
            }
            for (Integer integer : set) {
                VillagerTrades.ItemListing trade = trades[integer];
                MerchantOffer merchantoffer = trade.getOffer((Entity)current, random);
                if (merchantoffer == null) continue;
                offers.add((Object)merchantoffer);
            }
            info.cancel();
        }
    }

    @ModifyVariable(method={"addOffersFromItemListings(Lnet/minecraft/world/item/trading/MerchantOffers;[Lnet/minecraft/world/entity/npc/VillagerTrades$ItemListing;I)V"}, at=@At(value="HEAD"), ordinal=0, index=2)
    public VillagerTrades.ItemListing[] mahouBookTradeMixin(VillagerTrades.ItemListing[] trades) {
        Villager v;
        VillagerProfession prof;
        AbstractVillager current = (AbstractVillager)this;
        MahouSavedData data = Utils.getWorldMahou(current.level());
        int ADD_BOOK_LIMIT = 10;
        if (current instanceof Villager && (prof = (v = (Villager)current).getVillagerData().getProfession()).equals((Object)VillagerProfession.LIBRARIAN) && data != null && data.playerCreations != null && !data.playerCreations.isEmpty()) {
            ArrayList<FictionData> actual = new ArrayList<FictionData>();
            ArrayList available = new ArrayList(data.playerCreations.keySet());
            if (!available.isEmpty()) {
                ArrayList<Integer> locs = new ArrayList<Integer>();
                locs.add(v.level().random.nextInt(Math.min(ADD_BOOK_LIMIT, available.size())));
                for (Integer loc : locs) {
                    actual.add((FictionData)available.get(loc));
                }
                VillagerTrades.ItemListing[] new_trades = new VillagerTrades.ItemListing[trades.length + actual.size()];
                for (int k = 0; k < new_trades.length; ++k) {
                    new_trades[k] = k < trades.length ? trades[k] : new EmeraldForFiction((FictionData)actual.get(k - trades.length));
                }
                trades = new_trades;
            }
        }
        return trades;
    }
}

