/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.networking.MahouPackets;

public class ChunkMahouPacket
implements CustomPacketPayload {
    int mode;
    ConcurrentSet<BlockPos> set;
    int x;
    int z;
    public static final StreamCodec<ByteBuf, ChunkMahouPacket> STREAM_CODEC = new StreamCodec<ByteBuf, ChunkMahouPacket>(){

        public ChunkMahouPacket decode(ByteBuf buf) {
            ChunkMahouPacket packet = new ChunkMahouPacket();
            packet.decode(buf);
            return packet;
        }

        public void encode(ByteBuf buf, ChunkMahouPacket packet) {
            packet.encode(buf);
        }
    };

    public ChunkMahouPacket() {
    }

    public ChunkMahouPacket(ConcurrentSet<BlockPos> set, int x, int z) {
        this.x = x;
        this.z = z;
        this.set = set;
        this.mode = 0;
    }

    public ChunkMahouPacket(ConcurrentSet<BlockPos> set, int x, int z, int mode) {
        this.x = x;
        this.z = z;
        this.set = set;
        this.mode = mode;
    }

    public void decode(ByteBuf buf) {
        this.mode = buf.readInt();
        this.x = buf.readInt();
        this.z = buf.readInt();
        this.set = new ConcurrentSet();
        int sz = buf.readInt();
        for (int i = 0; i < sz; ++i) {
            this.set.add((Object)new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
        }
    }

    public void encode(ByteBuf buf) {
        buf.writeInt(this.mode);
        buf.writeInt(this.x);
        buf.writeInt(this.z);
        if (this.set != null && this.set.size() > 0) {
            buf.writeInt(this.set.size());
            for (BlockPos p : this.set) {
                if (p == null) continue;
                buf.writeInt(p.getX());
                buf.writeInt(p.getY());
                buf.writeInt(p.getZ());
            }
        } else {
            buf.writeInt(0);
        }
    }

    public static void handle(ChunkMahouPacket message, IPayloadContext context) {
        ClientPacketHandler.chunkMahouPacketHandler(message);
    }

    public CustomPacketPayload.Type<ChunkMahouPacket> type() {
        return MahouPackets.CHUNK_MAHOU_TYPE;
    }
}

