/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.event.ModelEvent;
import org.joml.Vector3f;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.shader.ModShaders;

public class RenderBaseItem {
    public static ModelResourceLocation standby = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/weapon_projectile_bow_standby"));
    public static ModelResourceLocation pulling0 = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/weapon_projectile_bow_pulling_0"));
    public static ModelResourceLocation pulling1 = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/weapon_projectile_bow_pulling_1"));
    public static ModelResourceLocation pulling2 = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/weapon_projectile_bow_pulling_2"));
    public static ModelResourceLocation caliburn = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/caliburn_model"));
    public static ModelResourceLocation redkeymodel = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/proximity_projection_key"));
    public static ModelResourceLocation treasuryGauntlet = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/treasury_projection_gauntlet_model"));
    public static ModelResourceLocation morgan = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/morgan_model"));
    public static ModelResourceLocation clarent = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/clarent_model"));
    public static ModelResourceLocation mysticCode = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/mystic_code_model"));
    public static ModelResourceLocation mysticCodeFirstSorcery = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/mystic_code_first_sorcery_model"));
    public static ModelResourceLocation staff = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/staff_emrys_model"));
    public static ModelResourceLocation rhongomyniad = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/rhongomyniad_model"));
    public static ModelResourceLocation replica = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/replica_model"));
    public static ModelResourceLocation rule_breaker = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/rule_breaker_model"));
    public static ModelResourceLocation spatial_staff = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/spatial_disorientation_staff_model"));
    public static ModelResourceLocation mystic_staff = RenderBaseItem.getMRL(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"item/mystic_staff_model"));

    public static ModelResourceLocation getMRL(ResourceLocation rl) {
        return new ModelResourceLocation(rl, "standalone");
    }

    public static void registerOtherModels(ModelEvent.RegisterAdditional event) {
        event.register(standby);
        event.register(pulling0);
        event.register(pulling1);
        event.register(pulling2);
        event.register(redkeymodel);
        event.register(treasuryGauntlet);
        event.register(caliburn);
        event.register(morgan);
        event.register(clarent);
        event.register(mysticCode);
        event.register(mysticCodeFirstSorcery);
        event.register(staff);
        event.register(rhongomyniad);
        event.register(replica);
        event.register(rule_breaker);
        event.register(spatial_staff);
        event.register(mystic_staff);
    }

    public static void render(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int var1, int var2, ModelResourceLocation rl) {
        RenderBaseItem.render(stack, matrix, buffer, var1, var2, rl, null, false);
    }

    public static void render(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int var1, int var2, ModelResourceLocation rl, boolean bright) {
        RenderBaseItem.render(stack, matrix, buffer, var1, var2, rl, null, bright);
    }

    public static void render(ItemStack stack, PoseStack matrix, MultiBufferSource buffer, int var1, int var2, ModelResourceLocation rl, RenderType type, boolean bright) {
        Minecraft mc = Minecraft.getInstance();
        RenderType rendertype = ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)false);
        BakedModel ibakedmodel = mc.getModelManager().getModel(rl);
        Vector3f DIFFUSE_LIGHT_0 = (Vector3f)Util.make((Object)new Vector3f(0.0f, 1.0f, 0.0f), Vector3f::normalize);
        Vector3f DIFFUSE_LIGHT_1 = (Vector3f)Util.make((Object)new Vector3f(0.0f, -1.0f, 0.0f), Vector3f::normalize);
        RenderSystem.setShader(() -> ModShaders.FULLBRIGHT_QUADS);
        RenderType rendertype1 = Objects.equals(rendertype, Sheets.translucentItemSheet()) ? Sheets.translucentCullBlockSheet() : rendertype;
        if (type != null) {
            rendertype1 = type;
        }
        if (bright) {
            rendertype1 = MahoujinRenderType.wrapBrightLayer(rendertype1);
        }
        ibakedmodel.getTransforms().getTransform(ItemDisplayContext.FIXED);
        VertexConsumer ivertexbuilder = RenderBaseItem.getBuffer(buffer, rendertype1, stack.hasFoil());
        RenderBaseItem.renderModel(ibakedmodel, stack, 240, 240, matrix, ivertexbuilder);
    }

    public static VertexConsumer getBuffer(MultiBufferSource bufferIn, RenderType renderTypeIn, boolean glintIn) {
        VertexConsumer tp = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)renderTypeIn, (boolean)true, (boolean)glintIn);
        return tp;
    }

    public static void renderModel(BakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, PoseStack matrixStackIn, VertexConsumer bufferIn) {
        RandomSource random = RandomSource.create((long)42L);
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            Minecraft.getInstance().getItemRenderer().renderQuadList(matrixStackIn, bufferIn, modelIn.getQuads((BlockState)null, direction, random), stack, combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        Minecraft.getInstance().getItemRenderer().renderQuadList(matrixStackIn, bufferIn, modelIn.getQuads((BlockState)null, (Direction)null, random), stack, combinedLightIn, combinedOverlayIn);
    }
}

