/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block.spells;

import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.BlockBase;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.block.spells.MahoujinBlockTileEntity;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.catalysts.PowderedCatalyst;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.displacement.OrderedDisplacementMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.AlchemicalExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ChronalExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.UnorderedList;
import stepsword.mahoutsukai.util.Utils;

public class Mahoujin
extends MahoujinBlockTileEntity<MahoujinTileEntity> {
    public Mahoujin() {
        super("mahoujin");
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        MahoujinTileEntity mahoujin;
        if (!level.isClientSide && (mahoujin = (MahoujinTileEntity)((Object)this.getTileEntity(level, pos))) != null && stack.getItem() instanceof PowderedCatalyst && mahoujin.getNumCatalysts() < 3) {
            mahoujin.setCasterUUID(player.getUUID());
            if (mahoujin.addCatalyst((PowderedCatalyst)stack.getItem())) {
                stack.shrink(1);
                this.transformToSpell(mahoujin, level, player, pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        IMahou mahou;
        MahoujinTileEntity mahoujin;
        if (!level.isClientSide && (mahoujin = (MahoujinTileEntity)((Object)this.getTileEntity(level, pos))) != null && mahoujin.getNumCatalysts() == 0 && (mahou = Utils.getPlayerMahou(player)) != null && mahou.getLastRecipe() != null && mahou.getLastRecipe().size() == 3) {
            boolean cloth = mahou.getLastRecipeCloth();
            UnorderedList ul = mahou.getLastRecipe();
            boolean hasClothInInventory = false;
            boolean hasAllCatalysts = true;
            Set<String> hs = ul.getKeys();
            HashMap<String, Integer> zz = new HashMap<String, Integer>();
            for (String h : hs) {
                zz.put(h, ul.get(h));
            }
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                IItemHandler inv;
                ItemStack st = (ItemStack)player.getInventory().items.get(i);
                if (st.getItem() instanceof PowderedCatalyst) {
                    PowderedCatalyst c = (PowderedCatalyst)st.getItem();
                    for (String s : hs) {
                        if (!c.getCatalystName().equals(s)) continue;
                        if (counts.containsKey(s)) {
                            counts.put(s, (Integer)counts.get(s) + st.getCount());
                            continue;
                        }
                        counts.put(s, st.getCount());
                    }
                } else if (Utils.getInventory(st) != null && (inv = Utils.getInventory(st)) != null) {
                    for (int j = 0; j < inv.getSlots(); ++j) {
                        ItemStack st2 = inv.getStackInSlot(j);
                        if (st2.getItem() instanceof PowderedCatalyst) {
                            PowderedCatalyst c = (PowderedCatalyst)st2.getItem();
                            for (String s : hs) {
                                if (!c.getCatalystName().equals(s)) continue;
                                if (counts.containsKey(s)) {
                                    counts.put(s, (Integer)counts.get(s) + st2.getCount());
                                    continue;
                                }
                                counts.put(s, st2.getCount());
                            }
                        }
                        if (st2.getItem() != Item.byBlock((Block)((Block)ModBlocks.spellClothBlock.get()))) continue;
                        hasClothInInventory = true;
                    }
                }
                if (st.getItem() != Item.byBlock((Block)((Block)ModBlocks.spellClothBlock.get()))) continue;
                hasClothInInventory = true;
            }
            for (String s : hs) {
                if (counts.containsKey(s)) {
                    if (ul.get(s) <= (Integer)counts.get(s)) continue;
                    hasAllCatalysts = false;
                    continue;
                }
                hasAllCatalysts = false;
            }
            boolean clothTaken = false;
            if (hasAllCatalysts && (!cloth || hasClothInInventory)) {
                for (int i = 0; i < player.getInventory().items.size(); ++i) {
                    IItemHandler inv;
                    ItemStack s = (ItemStack)player.getInventory().items.get(i);
                    if (s.isEmpty()) continue;
                    if (cloth && s.getItem() == Item.byBlock((Block)((Block)ModBlocks.spellClothBlock.get())) && !clothTaken) {
                        s.shrink(1);
                        clothTaken = true;
                        mahoujin.setCloth(true);
                    }
                    if (s.getItem() instanceof PowderedCatalyst) {
                        int r;
                        String name = ((PowderedCatalyst)s.getItem()).getCatalystName();
                        if (!zz.containsKey(name) || (r = ((Integer)zz.get(name)).intValue()) <= 0) continue;
                        if (s.getCount() >= r) {
                            s.shrink(r);
                            zz.put(name, 0);
                            continue;
                        }
                        if (s.getCount() >= r) continue;
                        s.shrink(s.getCount());
                        zz.put(name, r - s.getCount());
                        continue;
                    }
                    if (Utils.getInventory(s) == null || (inv = Utils.getInventory(s)) == null) continue;
                    for (int j = 0; j < inv.getSlots(); ++j) {
                        int r;
                        String name;
                        ItemStack st2 = inv.getStackInSlot(j);
                        if (cloth && st2.getItem() == Item.byBlock((Block)((Block)ModBlocks.spellClothBlock.get())) && !clothTaken) {
                            st2.shrink(1);
                            clothTaken = true;
                            mahoujin.setCloth(true);
                        }
                        if (!(st2.getItem() instanceof PowderedCatalyst) || !zz.containsKey(name = ((PowderedCatalyst)st2.getItem()).getCatalystName()) || (r = ((Integer)zz.get(name)).intValue()) <= 0) continue;
                        if (st2.getCount() >= r) {
                            st2.shrink(r);
                            zz.put(name, 0);
                            continue;
                        }
                        if (st2.getCount() >= r) continue;
                        st2.shrink(st2.getCount());
                        zz.put(name, r - st2.getCount());
                    }
                }
                mahoujin.setCatalysts(ul);
                this.transformToSpell(mahoujin, level, player, pos);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void transformToSpell(MahoujinTileEntity mahoujin, Level worldIn, Player playerIn, BlockPos pos) {
        if (mahoujin.getNumCatalysts() == 3) {
            boolean gamestages;
            BlockBase newBlock = MahoujinRecipeRegistrar.recipes.get(mahoujin.getCatalysts());
            boolean bl = gamestages = MahouTsukaiMod.gamestages.reachedStage((ServerPlayer)playerIn, Mahoujin.getClassOfSpell(mahoujin.getCatalysts())) || MahouTsukaiMod.gamestages.reachedStage((ServerPlayer)playerIn, "mahoutsukai_" + ResourceLocation.parse((String)Utils.getRegistryName(newBlock, worldIn)).getPath());
            if (!MTConfig.GAMESTAGES_ENABLED) {
                gamestages = true;
            }
            boolean banned = EffectUtil.inBlockBlacklist(newBlock, MTConfig.SPELL_BLACKLIST, worldIn);
            if (gamestages && newBlock != null && !banned) {
                UnorderedList catalystsCarry = mahoujin.getCatalysts();
                UUID casterUUIDCarry = mahoujin.getCasterUUID();
                boolean cloth = mahoujin.hasCloth();
                boolean needsCloth = MahoujinRecipeRegistrar.needsCloth.containsKey(catalystsCarry) && MahoujinRecipeRegistrar.needsCloth.get(catalystsCarry) != false;
                boolean fay = mahoujin.isFay();
                if (!needsCloth || cloth) {
                    IMahou mahou;
                    worldIn.setBlockAndUpdate(pos, newBlock.defaultBlockState());
                    MahoujinTileEntity mte = (MahoujinTileEntity)worldIn.getBlockEntity(pos);
                    if (mte != null) {
                        mte.setCatalysts(catalystsCarry);
                        mte.setCasterUUID(casterUUIDCarry);
                        mte.setCloth(cloth);
                        mte.setFay(fay);
                    }
                    if (mte instanceof OrderedDisplacementMahoujinTileEntity) {
                        OrderedDisplacementMahoujinTileEntity odmte = (OrderedDisplacementMahoujinTileEntity)mte;
                        odmte.setTeleporterId(worldIn.getGameTime());
                    }
                    if (mte instanceof ChronalExchangeMahoujinTileEntity) {
                        ((ChronalExchangeMahoujinTileEntity)mte).setTime(0L);
                    }
                    if (mte instanceof AlchemicalExchangeMahoujinTileEntity) {
                        long z = worldIn.getDayTime() % 24000L;
                        if (z < 0L) {
                            z += 24000L;
                        }
                        z -= z % 20L;
                        ((AlchemicalExchangeMahoujinTileEntity)mte).setPlacedTime(z + 100L);
                    }
                    if ((mahou = Utils.getPlayerMahou(playerIn)) != null) {
                        mahou.setLastRecipeCloth(cloth);
                        mahou.setLastRecipe(catalystsCarry);
                        PlayerManaManager.updateClientMahou((ServerPlayer)playerIn, mahou);
                    }
                }
            }
        }
    }

    public static String getClassOfSpell(UnorderedList lst) {
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedDiamond.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedDiamond.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_projection";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedEnder.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedEnder.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_displacement";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedQuartz.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedQuartz.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_familiar";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedGold.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedGold.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_mystic";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedIron.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedIron.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_boundary";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedEmerald.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedEmerald.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_exchange";
        }
        if (Mahoujin.hasCatalyst(lst, (PowderedCatalyst)((Object)ModItems.powderedEye.get())) && lst.get(((PowderedCatalyst)((Object)ModItems.powderedEye.get())).getCatalystName()) >= 2) {
            return "mahoutsukai_mystic_eyes";
        }
        return "mahoutsukai_secret";
    }

    public static boolean hasCatalyst(UnorderedList lst, PowderedCatalyst catalyst) {
        if (lst != null && lst.getKeys() != null && catalyst != null) {
            return lst.getKeys().contains(catalyst.getCatalystName());
        }
        return false;
    }

    @Override
    public Class<MahoujinTileEntity> getTileEntityClass() {
        return MahoujinTileEntity.class;
    }

    @Override
    @Nullable
    public MahoujinTileEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MahoujinTileEntity(blockPos, blockState);
    }
}

