/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.dataattachments.worldsave;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.component.WrittenBookContent;
import stepsword.mahoutsukai.MahouTsukaiMod;

public class FictionData {
    public int style;
    public int fame;
    public String text;
    public long creationTime;
    public UUID uuid;
    public WrittenBookContent content;

    public int hashCode() {
        return Objects.hash(this.fame, this.style, this.text, this.creationTime);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("style", this.style);
        tag.putInt("fame", this.fame);
        tag.putString("text", this.text);
        tag.putLong("creation", this.creationTime);
        tag.putUUID("caster", this.uuid);
        if (this.content != null) {
            try {
                Tag wbc = (Tag)WrittenBookContent.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.content).getOrThrow();
                tag.put("written_book_content", wbc);
            }
            catch (Exception e) {
                MahouTsukaiMod.logger.error((Object)e);
            }
        }
        return tag;
    }

    public static FictionData fromNBT(CompoundTag tag) {
        FictionData ret = new FictionData();
        if (tag.contains("style")) {
            ret.style = tag.getInt("style");
        }
        if (tag.contains("fame")) {
            ret.fame = tag.getInt("fame");
        }
        if (tag.contains("text")) {
            ret.text = tag.getString("text");
        }
        if (tag.contains("creation")) {
            ret.creationTime = tag.getLong("creation");
        }
        if (tag.hasUUID("caster")) {
            ret.uuid = tag.getUUID("caster");
        }
        if (tag.contains("written_book_content")) {
            try {
                ret.content = (WrittenBookContent)((Pair)WrittenBookContent.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("written_book_content")).getOrThrow()).getFirst();
            }
            catch (Exception e) {
                MahouTsukaiMod.logger.error((Object)e);
            }
        }
        return ret;
    }
}

