/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.integration.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.integration.emi.EntityEmiStack;
import stepsword.mahoutsukai.integration.emi.MahouEmiPlugin;
import stepsword.mahoutsukai.integration.emi.MahoujinEmiStack;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.util.UnorderedList;
import stepsword.mahoutsukai.util.Utils;

public class MorganEmiRecipe
extends BasicEmiRecipe {
    public MorganEmiRecipe(ResourceLocation id) {
        super(MahouEmiPlugin.SCROLL_RECIPES, id, 78, 70);
        UnorderedList recipe = MahoujinRecipeRegistrar.makeRecipe(MahoujinRecipeRegistrar.POWDERED_DIAMOND, MahoujinRecipeRegistrar.POWDERED_DIAMOND, MahoujinRecipeRegistrar.POWDERED_EMERALD);
        Block powerConsolidation = MahoujinRecipeRegistrar.recipes.get(recipe);
        String block_id = Utils.getRegistryKey(powerConsolidation, (Level)Minecraft.getInstance().level).getPath();
        MahoujinEmiStack block = new MahoujinEmiStack(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)("mahoujin_" + block_id + "_emi")), powerConsolidation, recipe);
        ArrayList<EntityEmiStack> killables = new ArrayList<EntityEmiStack>();
        for (String string : MTConfig.MORGAN_TRANSFORM_ENTITY_WHITELIST) {
            ResourceLocation loc = ResourceLocation.parse((String)string);
            EntityType type = (EntityType)((Registry)Minecraft.getInstance().level.registryAccess().registry(Registries.ENTITY_TYPE).get()).get(loc);
            try {
                killables.add(new EntityEmiStack(loc, type.create((Level)Minecraft.getInstance().level)));
            }
            catch (Exception e) {
                MahouTsukaiMod.logger.error("Not a living entity: " + String.valueOf(loc));
            }
        }
        this.inputs.add(EmiStack.of((ItemLike)((ItemLike)ModItems.caliburn.get())));
        this.inputs.add(EmiIngredient.of(killables));
        this.outputs.add(EmiStack.of((ItemLike)((ItemLike)ModItems.morgan.get())));
    }

    public void addWidgets(WidgetHolder widgets) {
        int px = 26;
        int offset = 0;
        int right = 0;
        widgets.addSlot((EmiIngredient)this.inputs.get(0), offset + right * px, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), offset + right * px, 26);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, offset + ++right * px, 26);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), (offset += 6) + ++right * px, 26).recipeContext((EmiRecipe)this);
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree();
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }

    @Nullable
    public RecipeHolder<?> getBackingRecipe() {
        return super.getBackingRecipe();
    }
}

