/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.shader.ModShaders;
import stepsword.mahoutsukai.util.Utils;

public class ClipWrappedRenderLayer
extends RenderType {
    private final RenderType delegate;
    public static double lastp = 0.0;

    public ClipWrappedRenderLayer(boolean flag, double pitch, double yaw, double x, double y, double z, double p, double size, RenderType delegate, Matrix4f m) {
        super("mahoutsukai" + delegate.name + "_with_clip", delegate.format(), delegate.mode(), delegate.bufferSize(), true, delegate.isOutline(), () -> {
            delegate.setupRenderState();
            if (ModShaders.CLIPPED_QUADS != null && !RenderUtils.turnOffMahouShaders()) {
                RenderSystem.setShader(() -> ModShaders.CLIPPED_QUADS);
                Camera cam = Minecraft.getInstance().gameRenderer.getMainCamera();
                Vec3 proj = cam.getPosition();
                Vec3 v = Utils.vecFromPitchYaw((float)pitch, (float)(180.0 - yaw)).scale(-1.0);
                Vector4f clipplane = new Vector4f(0.70710677f, 0.70710677f, 0.0f, 0.0f);
                clipplane.mul((Matrix4fc)m);
                clipplane.normalize();
                v = v.normalize();
                float d = (float)(v.x() * (proj.x - x) + v.y() * (proj.y - y) + v.z() * (proj.z - z));
                ModShaders.CLIPPED_QUADS.clip_plane(clipplane.x(), clipplane.y(), clipplane.z(), (float)((double)d + p));
                GL11.glEnable((int)12288);
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                lastp = p;
            }
        }, () -> {
            if (ModShaders.CLIPPED_QUADS != null && !RenderUtils.turnOffMahouShaders()) {
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
            }
            delegate.clearRenderState();
            if (ModShaders.CLIPPED_QUADS != null && !RenderUtils.turnOffMahouShaders()) {
                GL11.glDisable((int)12288);
            }
        });
        this.delegate = delegate;
    }

    public Optional<RenderType> outline() {
        return this.delegate.outline();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ClipWrappedRenderLayer && this.delegate.equals(((ClipWrappedRenderLayer)((Object)other)).delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate) * 2 + 1;
    }

    public static float pointToPlaneDistance(Vec3 normal, Vec3 point, float d) {
        float ret = (float)(normal.x * point.x + normal.y * point.y + normal.z * point.z + (double)d);
        return ret /= (float)Math.sqrt(normal.x * normal.x + normal.y * normal.y + normal.z * normal.z);
    }

    public static String getWouldBeName(RenderType delegate) {
        return "mahoutsukai" + delegate.name + "_with_clip0";
    }
}

