/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.replica;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.datacomponents.replica.ReplicaMahou;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ReplicaKnockbackParticlePacket;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.PlayerHelp;
import stepsword.mahoutsukai.util.Utils;

public class Replica
extends ItemBase {
    public static HashMap<String, DamageSource> DAMAGE_SOURCE_REGISTRY = new HashMap();

    public Replica() {
        super("replica", new Item.Properties().stacksTo(1).durability(MTConfig.REPLICA_DURABILITY));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack itemstack = player.getItemInHand(handIn);
        if (!player.level().isClientSide && player.isSprinting()) {
            Replica.coverMove(player);
        }
        player.startUsingItem(handIn);
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        if (count == 72000 && !player.level().isClientSide && player instanceof Player) {
            if (!player.isSprinting() && player.isDiscrete()) {
                Replica.saveTeleportLocation(stack, (Player)player);
            }
            if (!EffectUtil.hasBuff(player, ModEffects.REPLICA_SHOCKWAVE_COOLDOWN) && PlayerManaManager.drainMana((Player)player, MTConfig.REPLICA_ATTACK_MANA_COST, false, false) == MTConfig.REPLICA_ATTACK_MANA_COST) {
                this.bigKnockback((Player)player, stack);
                EffectUtil.buff(player, ModEffects.REPLICA_SHOCKWAVE_COOLDOWN, false, MTConfig.REPLICA_SHOCKWAVE_COOLDOWN, false);
            }
        }
        player.setDeltaMovement(0.0, 0.0, 0.0);
        player.hurtMarked = true;
    }

    public void bigKnockback(Player playerIn, ItemStack stack) {
        double maxRadius = MTConfig.REPLICA_ATTACK_RANGE;
        ReplicaKnockbackParticlePacket packet = new ReplicaKnockbackParticlePacket(playerIn.getX(), playerIn.getY() + (double)(playerIn.getBbHeight() / 2.0f), playerIn.getZ(), 0.2f, 0.2f, 0.2f);
        PacketHandler.sendTracking((Entity)playerIn, packet);
        PacketHandler.sendTo((ServerPlayer)playerIn, packet);
        List lst = playerIn.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerIn.getX() - maxRadius, playerIn.getY() - maxRadius, playerIn.getZ() - maxRadius, playerIn.getX() + maxRadius, playerIn.getY() + maxRadius, playerIn.getZ() + maxRadius));
        int multiplier = 0;
        double damage = MTConfig.REPLICA_BASE_DAMAGE;
        for (LivingEntity e : lst) {
            if (!ContractMahoujinTileEntity.isImmuneToSpell(playerIn.level(), playerIn.getUUID(), (Entity)e)) continue;
            ++multiplier;
        }
        for (LivingEntity e : lst) {
            if (ContractMahoujinTileEntity.isImmuneToSpell(playerIn.level(), playerIn.getUUID(), (Entity)e)) continue;
            String type = Replica.getDamageTypeForSlot(stack, Replica.getSelectedSlot(stack));
            DamageSource source = Replica.getDamageSource(type, (LivingEntity)playerIn);
            e.hurt(source, (float)Math.min((double)multiplier * damage, MTConfig.REPLICA_MAX_DAMAGE));
            Vec3 v = e.position().subtract(playerIn.position());
            this.boop((Entity)e, 3.0f, -v.x, -v.y, -v.z);
        }
    }

    public static void coverMove(Player player) {
        double totalRange = MTConfig.REPLICA_COVER_MOVE_RANGE;
        Vec3 myloc = new Vec3(player.getX(), player.getY(), player.getZ());
        List lst = player.level().getEntitiesOfClass(LivingEntity.class, new AABB(player.getX() - totalRange, player.getY() - totalRange, player.getZ() - totalRange, player.getX() + totalRange, player.getY() + totalRange, player.getZ() + totalRange));
        ArrayList<LivingEntity> inRange = new ArrayList<LivingEntity>();
        HashSet<LivingEntity> needsHelp = new HashSet<LivingEntity>();
        HashSet<LivingEntity> players = new HashSet<LivingEntity>();
        for (LivingEntity tmp : lst) {
            if (!EffectUtil.inRange(tmp, (LivingEntity)player, myloc, (int)totalRange, false) || !ContractMahoujinTileEntity.isImmuneToSpell(player.level(), player.getUUID(), (Entity)tmp) || player == tmp) continue;
            inRange.add(tmp);
            if (tmp instanceof Player) {
                players.add(tmp);
            }
            if (!Replica.needsHelp(tmp)) continue;
            needsHelp.add(tmp);
        }
        Collections.sort(inRange, Replica.getDistanceSorter((LivingEntity)player));
        LivingEntity e = Replica.coverMoveTarget(inRange, needsHelp, players);
        if (e != null) {
            Vec3 facing = Replica.coverMoveFacing(e);
            if (facing == null) {
                MahouTsukaiTeleporter.teleport((Entity)player, EffectUtil.getDimension(player.level()), e.position().add(new Vec3(1.0, 0.0, 0.0)));
                player.hurtMarked = true;
            } else {
                facing = facing.normalize();
                float pitch = (float)Math.asin(-facing.y);
                float yaw = (float)Math.atan2(facing.x, facing.z);
                player.yRot = EffectUtil.toDegrees(-yaw);
                player.xRot = EffectUtil.toDegrees(pitch);
                MahouTsukaiTeleporter.teleport((Entity)player, EffectUtil.getDimension(player.level()), e.position().add(facing.scale(0.2)));
                player.hurtMarked = true;
            }
        }
    }

    public static LivingEntity coverMoveTarget(ArrayList<LivingEntity> inRange, HashSet<LivingEntity> needsHelp, HashSet<LivingEntity> players) {
        for (LivingEntity living : inRange) {
            if (!needsHelp.contains(living) || !players.contains(living)) continue;
            return living;
        }
        for (LivingEntity living : inRange) {
            if (!needsHelp.contains(living)) continue;
            return living;
        }
        for (LivingEntity living : inRange) {
            if (!players.contains(living)) continue;
            return living;
        }
        Iterator<LivingEntity> iterator = inRange.iterator();
        if (iterator.hasNext()) {
            LivingEntity living;
            living = iterator.next();
            return living;
        }
        return null;
    }

    public static void saveTeleportLocation(ItemStack s, Player player) {
        ReplicaMahou mahou = Utils.getReplicaMahou(s);
        mahou.setLoc(player.position());
        mahou.setDim(EffectUtil.getDimension(player.level()).toString());
        Utils.setReplicaMahou(s, mahou);
    }

    public static Vec3 getTeleportLocation(ItemStack s) {
        ReplicaMahou mahou = Utils.getReplicaMahou(s);
        if (mahou.getLoc().isEmpty()) {
            return null;
        }
        return mahou.getLoc().get();
    }

    public static ResourceLocation getTeleportDimension(ItemStack s) {
        ReplicaMahou mahou = Utils.getReplicaMahou(s);
        if (mahou.getDim().isEmpty()) {
            return null;
        }
        return ResourceLocation.parse((String)mahou.getDim().get());
    }

    public static boolean getFriendlyOnly(ItemStack s) {
        ReplicaMahou mahou = Utils.getReplicaMahou(s);
        return mahou.getFriendly();
    }

    public static void setFriendlyOnly(ItemStack s, boolean b) {
        ReplicaMahou mahou = Utils.getReplicaMahou(s);
        mahou.setFriendly(b);
        Utils.setReplicaMahou(s, mahou);
    }

    public static Vec3 coverMoveFacing(LivingEntity e) {
        return Replica.coverMoveFacing(e, null);
    }

    public static Vec3 coverMoveFacing(LivingEntity e, Entity ignore) {
        int inTroubleRange = 15;
        List lst = e.level().getEntitiesOfClass(LivingEntity.class, new AABB(e.getX() - (double)inTroubleRange, e.getY() - (double)inTroubleRange, e.getZ() - (double)inTroubleRange, e.getX() + (double)inTroubleRange, e.getY() + (double)inTroubleRange, e.getZ() + (double)inTroubleRange));
        Collections.sort(lst, Replica.getDistanceSorter(e));
        lst.remove(e);
        if (ignore != null) {
            lst.remove(ignore);
        }
        Vec3 ret = null;
        for (LivingEntity attacker : lst) {
            if (ret == null) {
                ret = attacker.position().subtract(e.position());
            }
            if (attacker.getLastHurtByMob() != e && (!(attacker instanceof Mob) || ((Mob)attacker).getTarget() != e) && (!(attacker instanceof Player) || ContractMahoujinTileEntity.isImmuneToSpell(e.level(), e.getUUID(), (Entity)attacker))) continue;
            ret = attacker.position().subtract(e.position());
            return ret;
        }
        return ret;
    }

    public static Comparator<LivingEntity> getDistanceSorter(final LivingEntity player) {
        Comparator<LivingEntity> compareDistance = new Comparator<LivingEntity>(){

            @Override
            public int compare(LivingEntity o1, LivingEntity o2) {
                double d = o1.distanceTo((Entity)player) - o2.distanceTo((Entity)player);
                if (d < 0.0) {
                    return -1;
                }
                if (d > 0.0) {
                    return 1;
                }
                return 0;
            }
        };
        return compareDistance;
    }

    public static boolean needsHelp(LivingEntity e) {
        int inTroubleRange = 15;
        List lst = e.level().getEntitiesOfClass(LivingEntity.class, new AABB(e.getX() - (double)inTroubleRange, e.getY() - (double)inTroubleRange, e.getZ() - (double)inTroubleRange, e.getX() + (double)inTroubleRange, e.getY() + (double)inTroubleRange, e.getZ() + (double)inTroubleRange));
        for (LivingEntity attacker : lst) {
            if (attacker.getLastHurtByMob() != e && (!(attacker instanceof Mob) || ((Mob)attacker).getTarget() != e)) continue;
            return true;
        }
        return false;
    }

    public static void replicaBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer().getMainHandItem().getItem() instanceof Replica) {
            ItemStack s;
            boolean friendly = Replica.getFriendlyOnly(s = event.getPlayer().getMainHandItem());
            Replica.setFriendlyOnly(s, !friendly);
            MutableComponent tt = friendly ? Component.translatable((String)"mahoutsukai.replica.friendlyoff") : Component.translatable((String)"mahoutsukai.replica.friendlyon");
            event.getPlayer().displayClientMessage((Component)tt, true);
        }
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.hasImpulse = true;
        float f = Mth.sqrt((float)((float)(x * x + z * z + y * y)));
        Vec3 motion = entity.getDeltaMovement();
        double motionX = motion.x();
        double motionY = motion.y();
        double motionZ = motion.z();
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.hurtMarked = true;
        if (entity.onGround()) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        entity.setDeltaMovement(motionX, motionY, motionZ);
    }

    public static void setSelectedSlot(ItemStack s, int i) {
        ReplicaMahou mahou = Utils.getReplicaMahou(s);
        mahou.setSlot(i);
        Utils.setReplicaMahou(s, mahou);
    }

    public static int getSelectedSlot(ItemStack s) {
        ReplicaMahou mahou = Utils.getReplicaMahou(s);
        return mahou.getSlot();
    }

    public static String getDamageTypeForSlot(ItemStack s, int i) {
        ReplicaMahou mahou = Utils.getReplicaMahou(s);
        if (mahou.getTypes() != null && mahou.getTypes().size() > i) {
            return mahou.getTypes().get(i);
        }
        return "EMPTY";
    }

    public static void tryAddDamageType(ItemStack s, DamageSource source, LivingEntity e) {
        String type = source.getMsgId();
        if (DAMAGE_SOURCE_REGISTRY.isEmpty()) {
            Replica.initVanillaDamageTypes(e.damageSources());
        }
        if (!(EffectUtil.inGenericBlacklist(type, MTConfig.REPLICA_BANNED_DAMAGE_TYPES) || !DAMAGE_SOURCE_REGISTRY.containsKey(type) && Replica.getDamageSource(type, e).equals(e.damageSources().generic()))) {
            String slot;
            ReplicaMahou mahou = Utils.getReplicaMahou(s);
            ArrayList<String> types = mahou.getTypes();
            for (int i = 0; i < 6 && !(slot = Replica.getDamageTypeForSlot(s, i)).equals(type); ++i) {
                if (!slot.equals("EMPTY")) continue;
                types.set(i, type);
                break;
            }
            mahou.setTypes(types);
            Utils.setReplicaMahou(s, mahou);
        }
    }

    public static void replicaLivingAttack(LivingIncomingDamageEvent event) {
        DamageSource source = event.getSource();
        Replica.replicaDamageSource(event.getEntity(), source);
    }

    public static boolean replicaLivingHurt(LivingIncomingDamageEvent event) {
        DamageSource source = event.getSource();
        if (event.getEntity() != null && event.getEntity().getUseItem().getItem() instanceof Replica) {
            for (int i = 0; i < 6; ++i) {
                String s = Replica.getDamageTypeForSlot(event.getEntity().getUseItem(), i);
                if (!s.equals(source.getMsgId())) continue;
                event.setAmount(0.0f);
                return true;
            }
        }
        return false;
    }

    public static void replicaDamageSource(LivingEntity entity, DamageSource source) {
        if (!entity.level().isClientSide && entity.isBlocking() && entity.getUseItem().getItem() instanceof Replica) {
            Replica.tryAddDamageType(entity.getUseItem(), source, entity);
            entity.getUseItem().hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
        }
        if (!MTConfig.REPLICA_DISABLED) {
            ServerPlayer e;
            IMahou mahou;
            boolean blocking = entity.isBlocking();
            boolean hasShield = entity.getUseItem().getItem() instanceof ShieldItem;
            boolean isPlayer = entity instanceof ServerPlayer;
            if (blocking && hasShield && isPlayer && (mahou = Utils.getPlayerMahou((Player)(e = (ServerPlayer)entity))) != null) {
                boolean offHand;
                boolean damageExchange = (double)mahou.getDamageExchangeUses() > 0.9 * (double)MTConfig.DAMAGE_EXCHANGE_CAP;
                boolean deathCollection = (double)mahou.getDeathCollectionUsesLeft() >= Math.min(100.0, MTConfig.DEATH_COLLECTION_MAX);
                boolean immunityExchange = EffectUtil.hasBuff((LivingEntity)e, ModEffects.IMMUNITY_EXCHANGE);
                boolean armor = e.getArmorValue() > 15;
                boolean mainHand = e.getMainHandItem().getItem() == Items.SHIELD;
                boolean strengthenedMain = StrengtheningSpellEffect.getStrengthened(e.getMainHandItem()) > 0;
                boolean bl = offHand = e.getOffhandItem().getItem() == Items.SHIELD && StrengtheningSpellEffect.getStrengthened(e.getOffhandItem()) > 0;
                if (offHand) {
                    PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_WRONG_HAND);
                } else {
                    int count = 0;
                    boolean[] conditions = new boolean[]{damageExchange, deathCollection, immunityExchange, armor};
                    for (int i = 0; i < conditions.length; ++i) {
                        if (!conditions[i]) continue;
                        ++count;
                    }
                    if (count >= 3 && mainHand) {
                        PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_NOT_STRENGTHENED);
                    }
                }
                if (strengthenedMain && mainHand) {
                    if (damageExchange) {
                        if (deathCollection) {
                            if (immunityExchange) {
                                if (armor) {
                                    e.getInventory().removeItemNoUpdate(e.getInventory().selected);
                                    ItemStack change = new ItemStack((ItemLike)ModItems.replica.get());
                                    if (MTConfig.REPLICA_IS_UNBREAKABLE) {
                                        change.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                                    }
                                    if (!e.getInventory().add(e.getInventory().selected, change)) {
                                        e.drop(change, false);
                                    }
                                    ((MahouTrigger)((Object)ModTriggers.REPLICA.get())).trigger(e);
                                } else {
                                    PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_NOT_ENOUGH_ARMOR);
                                }
                            } else {
                                PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_NO_IMMUNITY_EXCHANGE);
                            }
                        } else {
                            PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_NOT_ENOUGH_SOULS);
                        }
                    } else {
                        PlayerHelp.sendHelpMessage((Player)e, PlayerHelp.Message.REPLICA_NOT_ENOUGH_DAMAGE_ABSORPTION);
                    }
                }
            }
        }
    }

    public static void clearDamageTypes(ItemStack s) {
        ArrayList<String> newlist = new ArrayList<String>();
        for (int i = 0; i < 6; ++i) {
            newlist.add("EMPTY");
        }
        ReplicaMahou mahou = Utils.getReplicaMahou(s);
        mahou.setTypes(newlist);
        Utils.setReplicaMahou(s, mahou);
    }

    public static void initVanillaDamageTypes(DamageSources srcs) {
        Replica.addToRegistry(srcs.inFire(), srcs.lightningBolt(), srcs.onFire(), srcs.lava(), srcs.hotFloor(), srcs.inWall(), srcs.cramming(), srcs.drown(), srcs.starve(), srcs.cactus(), srcs.fall(), srcs.flyIntoWall(), srcs.fellOutOfWorld(), srcs.generic(), srcs.magic(), srcs.wither(), srcs.dragonBreath(), srcs.dryOut(), srcs.sweetBerryBush());
    }

    public static void addToRegistry(DamageSource ... src) {
        for (int i = 0; i < src.length; ++i) {
            DAMAGE_SOURCE_REGISTRY.put(src[i].getMsgId(), src[i]);
        }
    }

    public static DamageSource getDamageSource(String key, LivingEntity e) {
        DamageSource ret = e.damageSources().generic();
        DamageSources srcs = e.damageSources();
        Replica.initVanillaDamageTypes(e.damageSources());
        if (DAMAGE_SOURCE_REGISTRY.containsKey(key)) {
            ret = DAMAGE_SOURCE_REGISTRY.get(key);
        } else {
            DamageSource BEE_STING = srcs.sting(e);
            DamageSource MOB = srcs.mobAttack(e);
            DamageSource INDIRECT = srcs.noAggroMobAttack(e);
            DamageSource ARROW = srcs.arrow((AbstractArrow)new Arrow(EntityType.ARROW, e.level()), (Entity)e);
            DamageSource EXPLOSION = srcs.explosion((Entity)e, null);
            DamageSource THORNS = srcs.thorns((Entity)e);
            DamageSource WITHER_SKULL = srcs.witherSkull(new WitherSkull(EntityType.WITHER_SKULL, e.level()), (Entity)e);
            DamageSource TRIDENT = srcs.trident((Entity)e, (Entity)e);
            DamageSource FIREWORK = srcs.fireworks(new FireworkRocketEntity(e.level(), new ItemStack((ItemLike)Items.FIREWORK_ROCKET), e), (Entity)e);
            DamageSource THROWN = srcs.thrown((Entity)e, (Entity)e);
            HashMap<String, DamageSource> map = new HashMap<String, DamageSource>();
            map.put(BEE_STING.getMsgId(), BEE_STING);
            map.put(MOB.getMsgId(), MOB);
            map.put(INDIRECT.getMsgId(), INDIRECT);
            map.put(ARROW.getMsgId(), ARROW);
            map.put(EXPLOSION.getMsgId(), EXPLOSION);
            map.put(THORNS.getMsgId(), THORNS);
            map.put(WITHER_SKULL.getMsgId(), WITHER_SKULL);
            map.put(TRIDENT.getMsgId(), TRIDENT);
            map.put(FIREWORK.getMsgId(), FIREWORK);
            map.put(THROWN.getMsgId(), THROWN);
            if (map.containsKey(key)) {
                ret = (DamageSource)map.get(key);
            }
        }
        return ret;
    }

    public static void replicaExplosionProtection(ExplosionEvent.Detonate event) {
        List lst = event.getExplosion().getToBlow();
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        if (lst.size() > 0 || event.getAffectedEntities().size() > 0) {
            for (BlockPos p : lst) {
                if ((float)p.getX() < minX) {
                    minX = p.getX();
                }
                if ((float)p.getY() < minY) {
                    minY = p.getY();
                }
                if ((float)p.getZ() < minZ) {
                    minZ = p.getZ();
                }
                if ((float)p.getX() > maxX) {
                    maxX = p.getX();
                }
                if ((float)p.getY() > maxY) {
                    maxY = p.getY();
                }
                if (!((float)p.getZ() > maxZ)) continue;
                maxZ = p.getZ();
            }
            for (Entity e : event.getAffectedEntities()) {
                BlockPos p = e.blockPosition();
                if ((float)p.getX() < minX) {
                    minX = p.getX();
                }
                if ((float)p.getY() < minY) {
                    minY = p.getY();
                }
                if ((float)p.getZ() < minZ) {
                    minZ = p.getZ();
                }
                if ((float)p.getX() > maxX) {
                    maxX = p.getX();
                }
                if ((float)p.getY() > maxY) {
                    maxY = p.getY();
                }
                if (!((float)p.getZ() > maxZ)) continue;
                maxZ = p.getZ();
            }
            ChunkPos bottom = new ChunkPos(new BlockPos((int)(minX -= 14.0f), (int)(minY -= 14.0f), (int)(minZ -= 14.0f)));
            ChunkPos top = new ChunkPos(new BlockPos((int)(maxX += 14.0f), (int)(maxY += 14.0f), (int)(maxZ += 14.0f)));
            AABB aabb = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            List entities = event.getLevel().getEntitiesOfClass(Player.class, aabb);
            if (entities.size() > 0) {
                Iterator iter = lst.iterator();
                while (iter.hasNext()) {
                    boolean remove = false;
                    BlockPos p = (BlockPos)iter.next();
                    for (Player entity : entities) {
                        Vec3 vec1;
                        if (!(entity.getUseItem().getItem() instanceof Replica) || !Replica.isPointInRadiusOfCircle(entity, vec1 = EffectUtil.fromBlockPos(p).add(0.5, 0.5, 0.5))) continue;
                        remove = true;
                        break;
                    }
                    if (!remove) continue;
                    iter.remove();
                }
                Iterator affected = event.getAffectedEntities().iterator();
                while (affected.hasNext()) {
                    boolean remove = false;
                    Entity a = (Entity)affected.next();
                    Vec3 p = a.position();
                    Vec3 p2 = a.position().add(0.0, (double)a.getBbHeight(), 0.0);
                    for (Player entity : entities) {
                        if (!(entity.getUseItem().getItem() instanceof Replica) || !Replica.isPointInRadiusOfCircle(entity, p) && !Replica.isPointInRadiusOfCircle(entity, p2)) continue;
                        remove = true;
                        break;
                    }
                    if (!remove) continue;
                    affected.remove();
                }
            }
        }
    }

    public static boolean isPointInRadiusOfCircle(Player player, Vec3 pos) {
        Vec3 sphereMid = Replica.getSphereMid(player);
        double distance = pos.distanceTo(sphereMid);
        return distance < (double)Replica.getSphereMidRadius();
    }

    public static Vec3 getSphereMid(Player player) {
        Vec3 sphereMid = player.position().subtract(player.getLookAngle().normalize().scale((double)Replica.getSphereMidRadius() - 0.5));
        return sphereMid;
    }

    public static float getSphereMidRadius() {
        float sphereMidRadius = 3.8f;
        return sphereMidRadius;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.REPLICA_DURABILITY;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        if (toolAction == ItemAbilities.SHIELD_BLOCK) {
            return true;
        }
        return super.canPerformAction(stack, toolAction);
    }
}

