/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.butterfly.ButterflyEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

@OnlyIn(value=Dist.CLIENT)
public class RenderButterfly
extends EntityRenderer<ButterflyEntity> {
    private static final ResourceLocation butterfly1 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/entity/butterfly1.png");
    private static final ResourceLocation butterfly2 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/entity/butterfly2.png");
    private static final ResourceLocation butterfly3 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/entity/butterfly3.png");
    private static final ResourceLocation butterfly4 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/entity/butterfly4.png");
    private static final ResourceLocation butterfly5 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/entity/butterfly5.png");
    private static final ResourceLocation butterfly6 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/entity/butterfly6.png");
    private static final ResourceLocation butterfly7 = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/entity/butterfly7.png");
    private static final RenderType b1 = MahoujinRenderType.createMahoujinRenderType(butterfly1, 0, true);
    private static final RenderType b2 = MahoujinRenderType.createMahoujinRenderType(butterfly2, 0, true);
    private static final RenderType b3 = MahoujinRenderType.createMahoujinRenderType(butterfly3, 0, true);
    private static final RenderType b4 = MahoujinRenderType.createMahoujinRenderType(butterfly4, 0, true);
    private static final RenderType b5 = MahoujinRenderType.createMahoujinRenderType(butterfly5, 0, true);
    private static final RenderType b6 = MahoujinRenderType.createMahoujinRenderType(butterfly6, 0, true);
    private static final RenderType b7 = MahoujinRenderType.createMahoujinRenderType(butterfly7, 0, true);

    public RenderButterfly(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(ButterflyEntity entityIn, float entityYaw, float partialTicks, PoseStack matrix, MultiBufferSource buf, int packedLightIn) {
        boolean z;
        boolean bl = z = entityIn.getCasterUUID() != null && Minecraft.getInstance().player != null && Minecraft.getInstance().player.getUUID().equals(entityIn.getCasterUUID());
        if (MTConfig.BUTTERFLY_EFFECT_VISIBLE_TO_OTHERS || z) {
            matrix.pushPose();
            float angle = entityIn.prevangle + partialTicks * (entityIn.angle - entityIn.prevangle);
            float size = entityIn.getSize();
            float yaw = this.calcPartialYaw(entityIn.yRot, entityIn.yRotO, partialTicks);
            matrix.scale(size, size, size);
            RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(entityIn.xRot, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(angle, 0.0f, 0.0f, 1.0f, matrix);
            this.drawWing(entityIn, matrix, 0.0f);
            RenderUtils.rotateQ(180.0f - 2.0f * angle, 0.0f, 0.0f, 1.0f, matrix);
            this.drawWing(entityIn, matrix, 0.0f);
            matrix.popPose();
        }
    }

    public ResourceLocation getTextureLocation(ButterflyEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    private void drawWing(ButterflyEntity e, PoseStack matrix, float m) {
        this.drawTexture(m * 0.0f, matrix, 0.0f, 0.0f, 0.0f, 1.0f, b1);
        this.drawTexture(m * 0.001f, matrix, e.colors[0][0] / 255.0f, e.colors[0][1] / 255.0f, e.colors[0][2] / 255.0f, 1.0f, b2);
        this.drawTexture(m * 0.001f, matrix, e.colors[1][0] / 255.0f, e.colors[1][1] / 255.0f, e.colors[1][2] / 255.0f, 1.0f, b3);
        this.drawTexture(m * 0.001f, matrix, e.colors[2][0] / 255.0f, e.colors[2][1] / 255.0f, e.colors[2][2] / 255.0f, 1.0f, b4);
        this.drawTexture(m * 0.001f, matrix, e.colors[3][0] / 255.0f, e.colors[3][1] / 255.0f, e.colors[3][2] / 255.0f, 1.0f, b5);
        this.drawTexture(m * 0.001f, matrix, e.colors[4][0] / 255.0f, e.colors[4][1] / 255.0f, e.colors[4][2] / 255.0f, 1.0f, b6);
        this.drawTexture(m * 0.001f, matrix, e.colors[5][0] / 255.0f, e.colors[5][1] / 255.0f, e.colors[5][2] / 255.0f, 1.0f, b7);
    }

    private void drawTexture(float cy, PoseStack matrix, float r, float g, float b, float a, RenderType type) {
        int lightmapX = 240;
        int lightmapY = 240;
        Matrix4f positionMatrix = matrix.last().pose();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer bb = buffer.getBuffer(type);
        bb.addVertex(positionMatrix, 0.0f, cy, 0.0f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(positionMatrix, 0.0f, cy, 1.0f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(positionMatrix, 1.0f, cy, 1.0f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(positionMatrix, 1.0f, cy, 0.0f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        RenderUtils.conditionalBatchEnder(type, (MultiBufferSource)buffer);
    }

    public float calcPartialYaw(float yw, float pyw, float partial) {
        if ((yw %= 360.0f) < 0.0f) {
            yw += 360.0f;
        }
        if (yw > 360.0f) {
            yw -= 360.0f;
        }
        if ((pyw %= 360.0f) < 0.0f) {
            pyw += 360.0f;
        }
        if (pyw > 360.0f) {
            pyw -= 360.0f;
        }
        if (yw < pyw) {
            float d2 = pyw - yw;
            float d1 = yw + (360.0f - pyw);
            if (d2 < d1) {
                return partial * d2 + yw;
            }
            return partial * d1 + pyw;
        }
        float d2 = yw - pyw;
        float d1 = pyw + (360.0f - yw);
        if (d2 < d1) {
            return partial * d2 + pyw;
        }
        return partial * d1 + yw;
    }
}

