/*
 * Decompiled with CFR 0.152.
 */
package com.lendill.aquila.util.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AquilaOreGenerationConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Aquila");
    public static boolean generateOre;

    public static void loadConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "aquila.json");
        try {
            if (!configFile.exists()) {
                AquilaOreGenerationConfig.saveDefaultConfig(configFile);
            }
            try (FileReader reader = new FileReader(configFile);){
                JsonObject description;
                JsonObject config = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                if (config.has("generateOre")) {
                    generateOre = config.get("generateOre").getAsBoolean();
                }
                if (config.has("description") && (description = config.getAsJsonObject("description")).has("text")) {
                    String string = description.get("text").getAsString();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error loading config from: {}", (Object)configFile.getPath(), (Object)e);
        }
    }

    private static void saveDefaultConfig(File configFile) {
        JsonObject defaultConfig = new JsonObject();
        JsonObject description = new JsonObject();
        description.addProperty("text", "Turning this to true will enable the generation of various crystals ores and other metals in your world.");
        defaultConfig.add("description", (JsonElement)description);
        defaultConfig.addProperty("generateOre", Boolean.valueOf(false));
        try (FileWriter writer = new FileWriter(configFile);){
            new Gson().toJson((JsonElement)defaultConfig, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Error saving default config to: {}", (Object)configFile.getPath(), (Object)e);
        }
    }

    public static void saveConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "aquila.json");
        JsonObject config = AquilaOreGenerationConfig.createConfig();
        try (FileWriter writer = new FileWriter(configFile);){
            new Gson().toJson((JsonElement)config, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Error saving config to: {}", (Object)configFile.getPath(), (Object)e);
        }
    }

    private static JsonObject createConfig() {
        JsonObject config = new JsonObject();
        JsonObject description = new JsonObject();
        description.addProperty("text", "Turning this to true will enable the generation of various crystals ores and other metals in your world.");
        config.add("description", (JsonElement)description);
        config.addProperty("generateOre", Boolean.valueOf(generateOre));
        return config;
    }
}

