/*
 * Decompiled with CFR 0.152.
 */
package com.lendill.aquila_core.util.block_families;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class AquilaBlockFamilyMain {
    private static final Map<class_2248, List<class_1799>> BLOCK_FAMILIES_PALETTE = new HashMap<class_2248, List<class_1799>>();
    private static final Map<class_1792, List<class_1799>> ITEM_FAMILIES_PALETTE = new HashMap<class_1792, List<class_1799>>();

    public static List<class_1799> getPaletteForBlock(class_2248 block) {
        return BLOCK_FAMILIES_PALETTE.getOrDefault(block, List.of());
    }

    public static List<class_1799> getPaletteForItem(class_1792 item) {
        return ITEM_FAMILIES_PALETTE.getOrDefault(item, List.of());
    }

    public static void registerFamily(String familyName, List<class_2248> blocks) {
        ArrayList familyPalette = new ArrayList();
        blocks.forEach(block -> {
            BLOCK_FAMILIES_PALETTE.put((class_2248)block, familyPalette);
            familyPalette.add(new class_1799((class_1935)block));
        });
    }

    public static void registerItemFamily(String itemFamilyName, List<class_1792> items) {
        ArrayList itemFamilyPalette = new ArrayList();
        items.forEach(item -> {
            ITEM_FAMILIES_PALETTE.put((class_1792)item, itemFamilyPalette);
            itemFamilyPalette.add(new class_1799((class_1935)item));
        });
    }

    public static void registerFamilyModId(String familyName, List<String> ids) {
        ArrayList familyPalette = new ArrayList();
        ArrayList blockEntries = new ArrayList();
        ArrayList itemEntries = new ArrayList();
        ids.forEach(id -> {
            class_2960 identifier = new class_2960(id);
            if (class_7923.field_41175.method_10250(identifier)) {
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(identifier);
                blockEntries.add(block);
                familyPalette.add(new class_1799((class_1935)block.method_8389()));
            } else if (class_7923.field_41178.method_10250(identifier)) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(identifier);
                itemEntries.add(item);
                familyPalette.add(new class_1799((class_1935)item));
            } else {
                System.err.println("ID " + id + " could not be found as a block or an item!");
            }
        });
        for (class_2248 block : blockEntries) {
            BLOCK_FAMILIES_PALETTE.put(block, familyPalette);
        }
        for (class_1792 item : itemEntries) {
            ITEM_FAMILIES_PALETTE.put(item, familyPalette);
        }
    }
}

