/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.leantimes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.leantimes.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.class_3528;
import net.minecraft.class_5699;

public record Config(AnimalConfig animals, PlantConfig plants) {
    public static Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AnimalConfig.CODEC.fieldOf("animals").forGetter(Config::animals), (App)PlantConfig.CODEC.fieldOf("plants").forGetter(Config::plants)).apply((Applicative)instance, Config::new));
    public static final String CONFIG_FNAME = String.valueOf(Platform.getConfigDirectory()) + "/leantimes.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static boolean loaded = false;
    public static final class_3528<Config> INSTANCE = new class_3528(Config::read);

    public Config() {
        this(new AnimalConfig(), new PlantConfig());
    }

    public static boolean isLoaded() {
        return loaded;
    }

    private static Config read() {
        File file = new File(CONFIG_FNAME);
        Config defaultConfig = new Config();
        if (file.isFile()) {
            Config config;
            FileReader in = new FileReader(file);
            try {
                config = (Config)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)in)).getOrThrow();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        Files.copy(Path.of(CONFIG_FNAME, new String[0]), Path.of(CONFIG_FNAME + ".old", new String[0]), new CopyOption[0]);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            in.close();
            return config;
        }
        try (FileWriter out = new FileWriter(file);){
            Optional result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)defaultConfig).resultOrPartial(System.out::println);
            if (result.isPresent()) {
                out.write(GSON.toJson((JsonElement)result.get()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        loaded = true;
        return defaultConfig;
    }

    public record AnimalConfig(float babyGrowthTimeMultiplier, int honeyNutrition, int landAnimalsMobcap, int fishMobcap, boolean animalIncreaseBreedingCooldownForEachChild, float fishCatchTimeMultiplier, float worldgenAnimalsMultiplier, boolean chickenIncreaseEggCooldownForEachEgg, float chickenEggSpawnChanceMultiplier) {
        public static Codec<AnimalConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("animal_growth_time_multiplier").forGetter(AnimalConfig::babyGrowthTimeMultiplier), (App)Codec.INT.fieldOf("honey_nutrition").forGetter(AnimalConfig::honeyNutrition), (App)Codec.INT.fieldOf("land_animals_mobcap").forGetter(AnimalConfig::landAnimalsMobcap), (App)Codec.INT.fieldOf("fish_mobcap").forGetter(AnimalConfig::fishMobcap), (App)Codec.BOOL.fieldOf("animal_increase_breeding_cooldown_for_each_child").forGetter(AnimalConfig::animalIncreaseBreedingCooldownForEachChild), (App)Codec.FLOAT.fieldOf("fish_catch_time_multiplier").forGetter(AnimalConfig::fishCatchTimeMultiplier), (App)Codec.FLOAT.fieldOf("worldgen_animals_multiplier").forGetter(AnimalConfig::worldgenAnimalsMultiplier), (App)Codec.BOOL.fieldOf("chicken_increase_egg_cooldown_for_each_egg").forGetter(AnimalConfig::chickenIncreaseEggCooldownForEachEgg), (App)Codec.FLOAT.fieldOf("chicken_egg_spawn_chance_multiplier").forGetter(AnimalConfig::chickenEggSpawnChanceMultiplier)).apply((Applicative)instance, AnimalConfig::new));

        public AnimalConfig() {
            this(4.0f, 1, 3, 3, true, 3.0f, 0.3f, true, 8.0f);
        }
    }

    public record PlantConfig(int sweetBerryGrowthTimeMultiplier, float farmlandTurnToDirtFrequency, float sweetBerryGrowthFailFrequency, boolean cropsSurviveOnDirt, boolean verticalPlantEnableChanges, double verticalPlantAgeMean, double verticalPlantAgeStd, int verticalPlantAgeMax) {
        public static Codec<PlantConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("sweet_berry_growth_time_multiplier").forGetter(PlantConfig::sweetBerryGrowthTimeMultiplier), (App)class_5699.method_65311((float)0.0f, (float)0.5f).fieldOf("farmland_turn_to_dirt_frequency").forGetter(PlantConfig::farmlandTurnToDirtFrequency), (App)class_5699.method_65311((float)0.0f, (float)0.5f).fieldOf("sweet_berry_growth_fail_frequency").forGetter(PlantConfig::sweetBerryGrowthFailFrequency), (App)Codec.BOOL.fieldOf("crops_survive_on_dirt").forGetter(PlantConfig::cropsSurviveOnDirt), (App)Codec.BOOL.fieldOf("vertical_plant_enable_changes").forGetter(PlantConfig::verticalPlantEnableChanges), (App)Codec.DOUBLE.fieldOf("vertical_plant_age_mean").forGetter(PlantConfig::verticalPlantAgeMean), (App)Codec.DOUBLE.fieldOf("vertical_plant_age_std").forGetter(PlantConfig::verticalPlantAgeStd), (App)Codec.INT.fieldOf("vertical_plant_age_max").forGetter(PlantConfig::verticalPlantAgeMax)).apply((Applicative)instance, PlantConfig::new));

        public PlantConfig() {
            this(10, 0.002f, 0.03f, true, true, 19.0, 6.0, 25);
        }
    }
}

