/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.leantimes.mixin;

import io.github.orlouge.leantimes.Config;
import io.github.orlouge.leantimes.interfaces.HasChildrenCount;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1429;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1429.class})
public class AnimalMixin
implements HasChildrenCount {
    @Unique
    private int leantimes$childrenCount = 0;

    @ModifyArg(method={"finalizeSpawnChildFromBreeding"}, index=0, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/entity/animal/Animal;setAge(I)V"))
    private int setSelfAge(int par1) {
        this.leantimes$increaseChildrenCount();
        return par1 * (1 + this.leantimes$childrenCount() * this.leantimes$childrenCount());
    }

    @Redirect(method={"finalizeSpawnChildFromBreeding"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/entity/animal/Animal;setAge(I)V"))
    private void setOtherAge(class_1429 instance, int i) {
        if (instance instanceof HasChildrenCount) {
            HasChildrenCount other = (HasChildrenCount)instance;
            other.leantimes$increaseChildrenCount();
            instance.method_5614(i * (1 + other.leantimes$childrenCount() * other.leantimes$childrenCount()));
        } else {
            instance.method_5614(i);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readChildrenCount(class_11368 valueInput, CallbackInfo ci) {
        valueInput.method_71439("LeanTimesChildrenCount").ifPresent(c -> {
            this.leantimes$childrenCount = c;
        });
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeChildrenCount(class_11372 valueOutput, CallbackInfo ci) {
        valueOutput.method_71465("LeanTimesChildrenCount", this.leantimes$childrenCount);
    }

    @Override
    public int leantimes$childrenCount() {
        return this.leantimes$childrenCount;
    }

    @Override
    public void leantimes$increaseChildrenCount() {
        if (((Config)Config.INSTANCE.method_15332()).animals().animalIncreaseBreedingCooldownForEachChild()) {
            ++this.leantimes$childrenCount;
        }
    }
}

