/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.leantimes.mixin;

import io.github.orlouge.leantimes.Config;
import io.github.orlouge.leantimes.interfaces.HasChildrenCount;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Animal.class})
public class AnimalMixin
implements HasChildrenCount {
    @Unique
    private int leantimes$childrenCount = 0;

    @ModifyArg(method={"finalizeSpawnChildFromBreeding(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/animal/Animal;Lnet/minecraft/world/entity/AgeableMob;)V"}, index=0, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/entity/animal/Animal;setAge(I)V"))
    private int setSelfAge(int par1) {
        this.leantimes$increaseChildrenCount();
        return par1 * (1 + this.leantimes$childrenCount() * this.leantimes$childrenCount());
    }

    @Redirect(method={"finalizeSpawnChildFromBreeding(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/animal/Animal;Lnet/minecraft/world/entity/AgeableMob;)V"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/entity/animal/Animal;setAge(I)V"))
    private void setOtherAge(Animal instance, int i) {
        if (instance instanceof HasChildrenCount) {
            HasChildrenCount other = (HasChildrenCount)instance;
            other.leantimes$increaseChildrenCount();
            instance.setAge(i * (1 + other.leantimes$childrenCount() * other.leantimes$childrenCount()));
        } else {
            instance.setAge(i);
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    private void readChildrenCount(ValueInput valueInput, CallbackInfo ci) {
        valueInput.getInt("LeanTimesChildrenCount").ifPresent(c -> {
            this.leantimes$childrenCount = c;
        });
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="TAIL")})
    private void writeChildrenCount(ValueOutput valueOutput, CallbackInfo ci) {
        valueOutput.putInt("LeanTimesChildrenCount", this.leantimes$childrenCount);
    }

    @Override
    public int leantimes$childrenCount() {
        return this.leantimes$childrenCount;
    }

    @Override
    public void leantimes$increaseChildrenCount() {
        if (((Config)Config.INSTANCE.get()).animals().animalIncreaseBreedingCooldownForEachChild()) {
            ++this.leantimes$childrenCount;
        }
    }
}

