/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.leantimes.mixin;

import io.github.orlouge.leantimes.Config;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Chicken.class})
public class ChickenMixin {
    @Unique
    private int leantimes$laidEggs = 0;

    @ModifyArg(method={"aiStep()V"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/util/RandomSource;nextInt(I)I"))
    public int increaseEggTime(int i) {
        if (!((Config)Config.INSTANCE.get()).animals().chickenIncreaseEggCooldownForEachEgg()) {
            return i;
        }
        int laid = ++this.leantimes$laidEggs;
        return i * (laid * laid);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    private void readLaidEggs(ValueInput valueInput, CallbackInfo ci) {
        valueInput.getInt("LeanTimesLaidEggs").ifPresent(e -> {
            this.leantimes$laidEggs = e;
        });
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="TAIL")})
    private void writeLaidEggs(ValueOutput valueOutput, CallbackInfo ci) {
        valueOutput.putInt("LeanTimesLaidEggs", this.leantimes$laidEggs);
    }
}

