/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.leantimes.mixin;

import io.github.orlouge.leantimes.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CropBlock.class})
public class CropBlockMixin {
    @Inject(method={"randomTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void preventNonFarmlandGrowth(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource, CallbackInfo ci) {
        if (((Config)Config.INSTANCE.get()).plants().cropsSurviveOnDirt() && serverLevel.getBlockState(blockPos.below()).is(BlockTags.DIRT)) {
            ci.cancel();
        }
    }

    @Inject(method={"canSurvive(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void canSurviveOnDirt(BlockState blockState, LevelReader levelReader, BlockPos blockPos, CallbackInfoReturnable<Boolean> cir) {
        if (((Config)Config.INSTANCE.get()).plants().cropsSurviveOnDirt() && levelReader.getBlockState(blockPos.below()).is(BlockTags.DIRT)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }
}

