/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.leantimes.mixin;

import io.github.orlouge.leantimes.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FarmBlock.class})
public abstract class FarmBlockMixin
extends Block {
    public FarmBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"randomTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void randomTurnToDirt(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource, CallbackInfo ci) {
        if (((Config)Config.INSTANCE.get()).plants().farmlandTurnToDirtFrequency() > 0.0f && (double)((Config)Config.INSTANCE.get()).plants().farmlandTurnToDirtFrequency() <= 0.5 && randomSource.nextInt((int)(1.0f / ((Config)Config.INSTANCE.get()).plants().farmlandTurnToDirtFrequency())) == 0 && !serverLevel.getBlockState(blockPos.above()).isAir()) {
            BlockState dirt = FarmBlockMixin.pushEntitiesUp((BlockState)blockState, (BlockState)Blocks.DIRT.defaultBlockState(), (LevelAccessor)serverLevel, (BlockPos)blockPos);
            serverLevel.setBlock(blockPos, dirt, 2);
            ci.cancel();
        }
    }
}

