/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.leantimes.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import io.github.orlouge.leantimes.Config;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={NaturalSpawner.class})
public class NaturalSpawnerMixin {
    @ModifyExpressionValue(method={"spawnMobsForChunkGeneration(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/Holder;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/util/RandomSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/MobSpawnSettings;getCreatureProbability()F")})
    private static float reduceCreatureProbability(float original, ServerLevelAccessor serverLevelAccessor, Holder<Biome> holder, ChunkPos chunkPos, RandomSource randomSource) {
        if (serverLevelAccessor.dimensionType().bedWorks()) {
            return original * ((Config)Config.INSTANCE.get()).animals().worldgenAnimalsMultiplier();
        }
        return original;
    }

    @ModifyExpressionValue(method={"spawnMobsForChunkGeneration(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/Holder;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/util/RandomSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/MobSpawnSettings$SpawnerData;minCount()I")})
    private static int reduceCreatureMinCount(int original) {
        return Math.min(original, 2);
    }
}

