/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.leantimes.mixin;

import io.github.orlouge.leantimes.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SweetBerryBushBlock.class})
public class SweetBerryBushBlockMixin {
    @ModifyConstant(method={"randomTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"}, constant={@Constant(intValue=5)})
    public int slowerGrowth(int constant) {
        return constant * ((Config)Config.INSTANCE.get()).plants().sweetBerryGrowthTimeMultiplier();
    }

    @Inject(method={"randomTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;setValue(Lnet/minecraft/world/level/block/state/properties/Property;Ljava/lang/Comparable;)Ljava/lang/Object;", shift=At.Shift.BEFORE)})
    public void randomDelete(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource, CallbackInfo ci) {
        if (((Config)Config.INSTANCE.get()).plants().sweetBerryGrowthFailFrequency() > 0.0f && randomSource.nextInt((int)(1.0f / ((Config)Config.INSTANCE.get()).plants().sweetBerryGrowthFailFrequency())) == 0) {
            BlockState air = Blocks.AIR.defaultBlockState();
            serverLevel.setBlock(blockPos, air, 2);
            serverLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)air));
            ci.cancel();
        }
    }
}

