/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.elytracontrol.handler;

import io.github.smootheez.elytracontrol.config.ElytraControlConfig;
import io.github.smootheez.elytracontrol.registry.KeyMappingRegistry;
import io.github.smootheez.elytracontrol.util.DebugMode;
import io.github.smootheez.elytracontrol.util.ElytraControlUtils;
import io.github.smootheez.smoothiezapi.config.ConfigManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1781;
import net.minecraft.class_1802;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_636;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class HandleEasyFly
implements ClientTickEvents.EndTick {
    private final ElytraControlConfig config = (ElytraControlConfig)ConfigManager.getConfig(ElytraControlConfig.class);
    private ActionStep actionStep = ActionStep.START_MOMENTUM;
    private boolean startEasyFly = false;

    public void onEndTick(class_310 client) {
        class_746 player = client.field_1724;
        class_636 gameMode = client.field_1761;
        if (player == null || gameMode == null) {
            return;
        }
        if (this.canInitiateEasyFly(client, client.field_1690, player) && this.hasFireworkInHand(player)) {
            this.startEasyFly = true;
        }
        this.startEasyFlyAction(player, gameMode);
    }

    private void startEasyFlyAction(class_746 player, class_636 gameMode) {
        if (this.startEasyFly) {
            switch (this.actionStep.ordinal()) {
                case 0: {
                    this.handleMomentumAction(player);
                    break;
                }
                case 1: {
                    this.handleStartFlying(player);
                    break;
                }
                case 2: {
                    this.handleUseFirework(player, gameMode);
                }
            }
        }
    }

    private void handleUseFirework(class_746 player, class_636 gameMode) {
        DebugMode.sendLoggerInfo("[Handle Easy Fly] Starting firework");
        for (class_1268 hand : class_1268.values()) {
            if (!(player.method_5998(hand).method_7909() instanceof class_1781)) continue;
            player.method_6104(hand);
            gameMode.method_2919((class_1657)player, hand);
            break;
        }
        this.startEasyFly = false;
        this.actionStep = ActionStep.START_MOMENTUM;
    }

    private void handleStartFlying(class_746 player) {
        DebugMode.sendLoggerInfo("[Handle Easy Fly] Starting player flight");
        player.method_23669();
        player.field_3944.method_52787((class_2596)new class_2848((class_1297)player, class_2848.class_2849.field_12982));
        this.actionStep = ActionStep.USE_FIREWORK;
    }

    private void handleMomentumAction(class_746 player) {
        DebugMode.sendLoggerInfo("[Handle Easy Fly] Starting player momentum");
        class_243 deltaMovement = player.method_18798();
        player.method_18800(deltaMovement.field_1352, ((Double)this.config.getUpwardVelocity().getValue()).doubleValue(), deltaMovement.field_1350);
        this.actionStep = ActionStep.START_FLYING;
    }

    private boolean canInitiateEasyFly(class_310 minecraft, class_315 options, class_746 player) {
        class_304 easyFly = KeyMappingRegistry.EASY_FLY;
        return (this.allowDefaultKey(options) || easyFly.method_1434()) && this.isCrosshairClear(minecraft) && player.method_6118(class_1304.field_6174).method_31574(class_1802.field_8833) && !player.field_6252 && !player.method_6128() && !player.method_5799() && !player.method_6115() && player.method_24828() && !ElytraControlUtils.isShouldDisableElytra() && (Boolean)this.config.getEasyFly().getValue() != false;
    }

    private boolean allowDefaultKey(class_315 options) {
        return options.field_1904.method_1434() && (Boolean)this.config.getEasyFlyAllowDefaultKey().getValue() != false;
    }

    private boolean hasFireworkInHand(class_746 player) {
        for (class_1268 hand : class_1268.values()) {
            if (!(player.method_5998(hand).method_7909() instanceof class_1781)) continue;
            return true;
        }
        return false;
    }

    private boolean isCrosshairClear(class_310 minecraft) {
        class_239 hitResult = minecraft.field_1765;
        return hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333;
    }

    static enum ActionStep {
        START_MOMENTUM,
        START_FLYING,
        USE_FIREWORK;

    }
}

