/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.elytracontrol.handler;

import io.github.smootheez.elytracontrol.config.ElytraControlConfig;
import io.github.smootheez.elytracontrol.registry.KeyMappingRegistry;
import io.github.smootheez.elytracontrol.util.DebugMode;
import io.github.smootheez.elytracontrol.util.ElytraControlUtils;
import io.github.smootheez.smoothiezapi.config.ConfigManager;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_5244;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class HandleElytraControl
implements ClientTickEvents.EndTick {
    private static final ElytraControlConfig CONFIG = (ElytraControlConfig)ConfigManager.getConfig(ElytraControlConfig.class);
    private int elytraTime = 0;
    private final Random random = new Random();

    public void onEndTick(class_310 client) {
        class_746 clientPlayer = client.field_1724;
        class_315 options = client.field_1690;
        if (clientPlayer == null) {
            return;
        }
        boolean isPlayerFlying = clientPlayer.method_6128();
        HandleElytraControl.disableElytra(clientPlayer, isPlayerFlying);
        this.defaultStopFlyingBehavior(options, isPlayerFlying, clientPlayer);
        this.customStopFlyingBehavior(clientPlayer, isPlayerFlying);
        this.countElytraTime(isPlayerFlying, options);
    }

    private static void disableElytra(class_746 clientPlayer, boolean isFallFlying) {
        while (KeyMappingRegistry.DISABLE_ELYTRA.method_1436()) {
            boolean shouldDisableElytra = !ElytraControlUtils.isShouldDisableElytra();
            ElytraControlUtils.setShouldDisableElytra(shouldDisableElytra);
            if (!Boolean.TRUE.equals(CONFIG.getDisableElytraNotification().getValue())) continue;
            HandleElytraControl.stopFallFlying(clientPlayer, isFallFlying);
            clientPlayer.method_7353((class_2561)class_5244.method_30619((class_2561)class_2561.method_43471((String)"notification.elytracontrol.disable_elytra"), (boolean)shouldDisableElytra), true);
        }
    }

    private void countElytraTime(boolean isPlayerFlying, class_315 options) {
        this.elytraTime = isPlayerFlying && !options.field_1903.method_1434() ? (this.elytraTime + 1) % 1000 : 0;
    }

    private void customStopFlyingBehavior(class_746 clientPlayer, boolean isFallFlying) {
        class_304 startKey = KeyMappingRegistry.START_FLYING;
        class_304 stopKey = KeyMappingRegistry.STOP_FLYING;
        if (startKey.method_1435(stopKey)) {
            this.handleSameKeyMode(clientPlayer, startKey, isFallFlying);
        } else {
            this.handleSeparateKeyMode(clientPlayer, startKey, stopKey, isFallFlying);
        }
    }

    private void handleSameKeyMode(class_746 player, class_304 key, boolean isFallFlying) {
        while (key.method_1436()) {
            HandleElytraControl.stopFallFlying(player, isFallFlying);
            HandleElytraControl.sendStartFallFlyingPacket(player);
        }
    }

    private void handleSeparateKeyMode(class_746 player, class_304 startKey, class_304 stopKey, boolean isFallFlying) {
        this.processStartFlying(player, startKey);
        this.processStopFlying(player, stopKey, isFallFlying);
    }

    private void processStartFlying(class_746 player, class_304 startKey) {
        while (startKey.method_1436()) {
            if (player.method_6128()) continue;
            HandleElytraControl.sendStartFallFlyingPacket(player);
        }
    }

    private void processStopFlying(class_746 player, class_304 stopKey, boolean isFallFlying) {
        while (stopKey.method_1436()) {
            HandleElytraControl.stopFallFlying(player, isFallFlying);
        }
    }

    private void defaultStopFlyingBehavior(class_315 options, boolean isPlayerFlying, class_746 clientPlayer) {
        int randomNumber = this.random.nextInt(3) + 1;
        if (options.field_1903.method_1436() && this.elytraTime > randomNumber && Boolean.TRUE.equals(CONFIG.getElytraControlAllowDefaultKey().getValue())) {
            HandleElytraControl.stopFallFlying(clientPlayer, isPlayerFlying);
        }
    }

    private static void stopFallFlying(class_746 clientPlayer, boolean isFallFlying) {
        if (!isFallFlying) {
            return;
        }
        DebugMode.sendLoggerInfo("Stopping Elytra flight");
        clientPlayer.method_66281();
        HandleElytraControl.sendStartFallFlyingPacket(clientPlayer);
    }

    private static void sendStartFallFlyingPacket(class_746 clientPlayer) {
        DebugMode.sendLoggerInfo("Sending start fall flying packet");
        clientPlayer.field_3944.method_52787((class_2596)new class_2848((class_1297)clientPlayer, class_2848.class_2849.field_12982));
    }
}

