/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.elytracontrol.handler;

import io.github.smootheez.elytracontrol.config.ElytraControlConfig;
import io.github.smootheez.elytracontrol.config.option.LockIconMode;
import io.github.smootheez.elytracontrol.config.option.OverlayPosition;
import io.github.smootheez.elytracontrol.util.ElytraControlUtils;
import io.github.smootheez.smoothiezapi.config.ConfigManager;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import net.minecraft.class_9848;

@Environment(value=EnvType.CLIENT)
public class HandleHudOverlay
implements HudElement {
    private static final class_2960 ELYTRA_ICON = class_2960.method_60656((String)"textures/item/elytra.png");
    private static final class_2960 CROSS_ICON = class_2960.method_60655((String)"elytracontrol", (String)"textures/gui/cross_icon.png");
    private final ElytraControlConfig config = (ElytraControlConfig)ConfigManager.getConfig(ElytraControlConfig.class);

    public void render(class_332 context, class_9779 tickCounter) {
        if (!ElytraControlUtils.isShouldDisableElytra()) {
            return;
        }
        this.renderOverlay(context, (OverlayPosition)((Object)this.config.getOverlayPosition().getValue()), (LockIconMode)((Object)this.config.getLockIconMode().getValue()));
    }

    private void renderOverlay(class_332 guiGraphics, OverlayPosition position, LockIconMode lockIconMode) {
        class_327 font = class_310.method_1551().field_1772;
        int screenWidth = guiGraphics.method_51421();
        int screenHeight = guiGraphics.method_51443();
        class_5250 translatableDisableText = class_2561.method_43471((String)"overlay.elytracontrol.disable_text");
        int iconSize = 16;
        int textWidth = font.method_27525((class_5348)translatableDisableText);
        Objects.requireNonNull(font);
        Positions positions = this.calculatePositions(position, lockIconMode, screenWidth, screenHeight, iconSize, textWidth, 9);
        int textColor = class_9848.method_61324((int)255, (int)255, (int)19, (int)19);
        if (lockIconMode == LockIconMode.ICON_TEXT || lockIconMode == LockIconMode.ICON_ONLY) {
            guiGraphics.method_25290(class_10799.field_56883, ELYTRA_ICON, positions.iconX(), positions.iconY(), 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            guiGraphics.method_25290(class_10799.field_56883, CROSS_ICON, positions.iconX(), positions.iconY(), 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        if (lockIconMode == LockIconMode.ICON_TEXT || lockIconMode == LockIconMode.TEXT_ONLY) {
            guiGraphics.method_51439(font, (class_2561)translatableDisableText, positions.textX(), positions.textY(), textColor, false);
        }
    }

    private Positions calculatePositions(OverlayPosition position, LockIconMode lockIconMode, int screenWidth, int screenHeight, int iconSize, int textWidth, int lineHeight) {
        int baseX = 3;
        int baseY = 3;
        int iconX = baseX;
        int iconY = baseY;
        int textX = baseX;
        int textY = iconY + iconSize / 2 - lineHeight / 2;
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        block0 : switch (position) {
            case TOP_LEFT: {
                if (lockIconMode != LockIconMode.ICON_TEXT) break;
                textX = iconX + iconSize + 5;
                break;
            }
            case TOP_MIDDLE: {
                switch (lockIconMode) {
                    case ICON_TEXT: {
                        iconX = centerX - (textWidth + iconSize) / 2;
                        textX = iconX + iconSize + 5;
                        break block0;
                    }
                    case TEXT_ONLY: {
                        textX = centerX - textWidth / 2;
                        break block0;
                    }
                    case ICON_ONLY: {
                        iconX = centerX - iconSize / 2;
                        break block0;
                    }
                }
                break;
            }
            case TOP_RIGHT: {
                switch (lockIconMode) {
                    case ICON_TEXT: {
                        iconX = screenWidth - iconSize - baseX;
                        textX = iconX - textWidth - 5;
                        break block0;
                    }
                    case TEXT_ONLY: {
                        textX = screenWidth - textWidth - baseX;
                        break block0;
                    }
                    case ICON_ONLY: {
                        iconX = screenWidth - iconSize - baseX;
                        break block0;
                    }
                }
                break;
            }
            case RIGHT_MIDDLE: {
                iconX = screenWidth - iconSize - baseX;
                iconY = centerY - iconSize / 2;
                switch (lockIconMode) {
                    case ICON_TEXT: {
                        textX = iconX - textWidth - 5;
                        textY = iconY + iconSize / 2 - lineHeight / 2;
                        break block0;
                    }
                    case TEXT_ONLY: {
                        textX = screenWidth - textWidth - baseX;
                        textY = centerY - lineHeight / 2;
                        break block0;
                    }
                }
                break;
            }
            case BOTTOM_RIGHT: {
                iconX = screenWidth - iconSize - baseX;
                iconY = screenHeight - baseY - iconSize;
                switch (lockIconMode) {
                    case ICON_TEXT: {
                        textX = iconX - textWidth - 5;
                        textY = iconY + iconSize / 2 - lineHeight / 2;
                        break block0;
                    }
                    case TEXT_ONLY: {
                        textX = screenWidth - textWidth - baseX;
                        textY = screenHeight - baseY - lineHeight;
                        break block0;
                    }
                }
                break;
            }
            case BOTTOM_LEFT: {
                iconY = screenHeight - baseY - iconSize;
                switch (lockIconMode) {
                    case ICON_TEXT: {
                        textX = iconX + iconSize + 5;
                        textY = iconY + iconSize / 2 - lineHeight / 2;
                        break block0;
                    }
                    case TEXT_ONLY: {
                        textY = screenHeight - baseY - lineHeight;
                        break block0;
                    }
                }
                break;
            }
            case LEFT_MIDDLE: {
                iconY = centerY - iconSize / 2;
                switch (lockIconMode) {
                    case ICON_TEXT: {
                        textX = iconX + iconSize + 5;
                        textY = iconY + iconSize / 2 - lineHeight / 2;
                        break block0;
                    }
                    case TEXT_ONLY: {
                        textY = centerY - lineHeight / 2;
                        break block0;
                    }
                }
            }
        }
        return new Positions(iconX, iconY, textX, textY);
    }

    private record Positions(int iconX, int iconY, int textX, int textY) {
    }
}

