/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.holdontoeverything.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.apple70cents.holdontoeverything.HoldOntoEverything;
import net.apple70cents.holdontoeverything.utils.LoggerUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;

public class ConfigStorage {
    public static final File FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "hold_onto_everything.json");
    private Map<String, Object> configMap;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static boolean configFileExists() {
        return FILE.exists();
    }

    public ConfigStorage(boolean useDefault) {
        this.readConfigFile(useDefault);
    }

    public Map getHashmap() {
        return this.configMap;
    }

    public ConfigStorage withDefault(Map<String, Object> defaultMap) {
        for (Map.Entry<String, Object> entry : defaultMap.entrySet()) {
            this.configMap.putIfAbsent(entry.getKey(), entry.getValue());
        }
        this.configMap.put("config.version", defaultMap.get("config.version"));
        return this;
    }

    public void readConfigFile(boolean loadDefault) {
        try {
            Reader reader = loadDefault ? new InputStreamReader(class_310.method_1551().getClass().getClassLoader().getResourceAsStream("assets/holdontoeverything/default_config.json")) : new BufferedReader(new FileReader(FILE));
            this.configMap = (Map)GSON.fromJson(reader, Map.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object get(String variableName) {
        return this.configMap.get(variableName);
    }

    public boolean getAsBool(String variableName) {
        return (Boolean)this.configMap.get(variableName);
    }

    public void set(String variableName, Object value) {
        this.configMap.put(variableName, value);
    }

    public void save() {
        HoldOntoEverything.enableDrop();
        LoggerUtils.info("[HoldOntoEverything] Saving configs.");
        try (FileWriter writer = new FileWriter(FILE);){
            GSON.toJson(this.configMap, (Appendable)writer);
        }
        catch (Exception e) {
            LoggerUtils.error("[HoldOntoEverything] Couldn't save config.");
            e.printStackTrace();
        }
    }
}

