/*
 * Decompiled with CFR 0.152.
 */
package net.apple70cents.holdontoeverything.utils;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.apple70cents.holdontoeverything.HoldOntoEverything;
import net.apple70cents.holdontoeverything.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;

public class ConfigScreenUtils {
    public static final Function<String, Optional<class_2561>> REGEX_COMPILE_ERROR_SUPPLIER = v -> {
        try {
            Pattern.compile(v);
            return Optional.empty();
        }
        catch (PatternSyntaxException e) {
            return Optional.of(TextUtils.of(e.getDescription()));
        }
    };
    public static final Function<String, Optional<class_2561>> REGEX_COMPILE_ERROR_SUPPLIER_ALLOW_STAR = v -> {
        if ("*".equals(v)) {
            return Optional.empty();
        }
        try {
            Pattern.compile(v);
            return Optional.empty();
        }
        catch (PatternSyntaxException e) {
            return Optional.of(TextUtils.of(e.getDescription()));
        }
    };

    public static class_2561 getTooltip(String key, String variableType) {
        return ConfigScreenUtils.getTooltip(key, variableType, HoldOntoEverything.DEFAULT_CONFIG.get(key));
    }

    public static class_2561 getTooltip(String key, String variableType, Object defaultVal) {
        String defaultValue;
        boolean isNull = defaultVal == null || defaultVal.toString().isBlank();
        String string = defaultValue = isNull ? "NULL" : defaultVal.toString();
        if (class_310.method_1551().field_1690.field_1827) {
            try {
                if (variableType.endsWith("List") && !((List)HoldOntoEverything.DEFAULT_CONFIG.get(key)).isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    for (int i = 0; i < ((List)HoldOntoEverything.DEFAULT_CONFIG.get(key)).size(); ++i) {
                        String ele = ((List)HoldOntoEverything.DEFAULT_CONFIG.get(key)).get(i).toString();
                        if (i != 0) {
                            sb.append(",");
                        }
                        if ("StringList".equals(variableType)) {
                            sb.append("\n  \u00a7r\u00a7f" + ele + "\u00a7r\u00a77");
                            continue;
                        }
                        sb.append("\n  {");
                        String[] keyAndValuePairs = ele.substring(1, ele.length() - 1).split(", ");
                        for (int j = 0; j < keyAndValuePairs.length; ++j) {
                            String ele2 = keyAndValuePairs[j];
                            int idx = ele2.indexOf("=");
                            sb.append("\n    \u00a7e" + ele2.substring(0, idx) + "\u00a7r\u00a77 = \u00a7f" + ele2.substring(idx + 1) + "\u00a7r\u00a77");
                        }
                        sb.append("\n  }");
                    }
                    sb.append("\n]");
                    defaultValue = sb.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            class_5250 defaults = ((class_5250)TextUtils.trans("gui.defaultValue", defaultValue)).method_27692(class_124.field_1080);
            class_5250 keyName = ((class_5250)TextUtils.of(key)).method_27692(class_124.field_1065);
            class_5250 main = ((class_5250)TextUtils.trans(key + ".@Tooltip")).method_27692(class_124.field_1068);
            class_5250 type = ((class_5250)TextUtils.trans("gui.variableType", variableType)).method_27692(class_124.field_1080);
            class_5250 tooltip = (class_5250)TextUtils.empty();
            tooltip.method_10852((class_2561)keyName).method_27693("\u00a7r\n").method_10852((class_2561)main).method_27693("\u00a7r\n").method_10852((class_2561)type).method_27693("\u00a7r\n").method_10852((class_2561)defaults);
            return tooltip;
        }
        return TextUtils.trans(key + ".@Tooltip");
    }

    public static TooltipListEntry getEntryBuilder(ConfigEntryBuilder eb, String type, String key, int ... args) {
        class_2561 tooltip = ConfigScreenUtils.getTooltip(key, type);
        switch (type) {
            case "boolean": {
                return eb.startBooleanToggle(TextUtils.trans(key), ((Boolean)HoldOntoEverything.CONFIG.get(key)).booleanValue()).setDefaultValue(((Boolean)HoldOntoEverything.DEFAULT_CONFIG.get(key)).booleanValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(v -> HoldOntoEverything.CONFIG.set(key, v)).build();
            }
            case "String": {
                return eb.startStrField(TextUtils.trans(key), (String)HoldOntoEverything.CONFIG.get(key)).setDefaultValue((String)HoldOntoEverything.DEFAULT_CONFIG.get(key)).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(v -> HoldOntoEverything.CONFIG.set(key, v)).build();
            }
            case "intSlider": {
                return eb.startIntSlider(TextUtils.trans(key), ((Number)HoldOntoEverything.CONFIG.get(key)).intValue(), args[0], args[1]).setDefaultValue(((Number)HoldOntoEverything.DEFAULT_CONFIG.get(key)).intValue()).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(v -> HoldOntoEverything.CONFIG.set(key, v)).build();
            }
            case "keycode": {
                return eb.startKeyCodeField(TextUtils.trans(key), class_3675.method_15981((String)((String)HoldOntoEverything.CONFIG.get(key)))).setDefaultValue(class_3675.method_15981((String)((String)HoldOntoEverything.DEFAULT_CONFIG.get(key)))).setTooltip(new class_2561[]{tooltip}).setKeySaveConsumer(keybind -> HoldOntoEverything.CONFIG.set(key, keybind.method_1441())).build();
            }
            case "StringList": {
                return eb.startStrList(TextUtils.trans(key), (List)HoldOntoEverything.CONFIG.get(key)).setDefaultValue((List)HoldOntoEverything.DEFAULT_CONFIG.get(key)).setTooltip(new class_2561[]{tooltip}).setSaveConsumer(v -> HoldOntoEverything.CONFIG.set(key, v)).build();
            }
        }
        return null;
    }
}

