/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.redpanda.mob;

import aquariusplayz.animalgarden.redpanda.mob.MobAnimations;
import aquariusplayz.animalgarden.redpanda.mob.ModMob;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public class ModMobModel<T extends ModMob>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_redpanda", (String)"redpanda"), "main");
    public static final ModelLayerLocation BABY_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_redpanda", (String)"redpanda_baby"), "main");
    private final ModelPart rootz;
    private final ModelPart head;
    private final ModelPart rightear;
    private final ModelPart leftear;
    private final ModelPart mouth;
    private final ModelPart nose;
    private final ModelPart righteye;
    private final ModelPart lefteyeball;
    private final ModelPart lefteye;
    private final ModelPart righteyeball;
    private final ModelPart body;
    private final ModelPart chest;
    private final ModelPart tail;
    private final ModelPart leftfrontleg;
    private final ModelPart rightfrontleg;
    private final ModelPart righthindleg;
    private final ModelPart lefthindleg;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public ModMobModel(ModelPart root) {
        this.rootz = root.getChild("rootz");
        this.head = this.rootz.getChild("head");
        this.rightear = this.head.getChild("rightear");
        this.leftear = this.head.getChild("leftear");
        this.mouth = this.head.getChild("mouth");
        this.nose = this.head.getChild("nose");
        this.righteye = this.head.getChild("righteye");
        this.lefteyeball = this.righteye.getChild("lefteyeball");
        this.lefteye = this.head.getChild("lefteye");
        this.righteyeball = this.lefteye.getChild("righteyeball");
        this.body = this.rootz.getChild("body");
        this.chest = this.body.getChild("chest");
        this.tail = this.body.getChild("tail");
        this.leftfrontleg = this.rootz.getChild("leftfrontleg");
        this.rightfrontleg = this.rootz.getChild("rightfrontleg");
        this.righthindleg = this.rootz.getChild("righthindleg");
        this.lefthindleg = this.rootz.getChild("lefthindleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rootz = partdefinition.addOrReplaceChild("rootz", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)5.5f));
        PartDefinition head = rootz.addOrReplaceChild("head", CubeListBuilder.create().texOffs(34, 18).addBox(-5.0f, -4.0f, -6.0f, 10.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(36, 40).addBox(-2.0f, 0.0f, -8.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-10.5f));
        PartDefinition rightear = head.addOrReplaceChild("rightear", CubeListBuilder.create().texOffs(42, 12).addBox(-3.0f, -2.0f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(20, 44).addBox(0.0f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-4.0f, (float)-4.5f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create().texOffs(36, 44).addBox(-1.0f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 44).addBox(0.0f, -2.0f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-4.0f, (float)-4.5f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(42, 0).addBox(-2.0f, 1.0f, -3.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-5.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(42, 8).addBox(-1.0f, -1.65f, -1.65f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)1.35f, (float)-6.65f));
        PartDefinition righteye = head.addOrReplaceChild("righteye", CubeListBuilder.create().texOffs(14, 44).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)0.0f, (float)-5.51f));
        PartDefinition lefteyeball = righteye.addOrReplaceChild("lefteyeball", CubeListBuilder.create().texOffs(42, 3).addBox(-1.5f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.51f)), PartPose.offset((float)0.5f, (float)-1.0f, (float)-0.03f));
        PartDefinition lefteye = head.addOrReplaceChild("lefteye", CubeListBuilder.create().texOffs(8, 44).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.0f, (float)-5.51f));
        PartDefinition righteyeball = lefteye.addOrReplaceChild("righteyeball", CubeListBuilder.create().texOffs(24, 35).addBox(-0.5f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.51f)), PartPose.offset((float)-0.5f, (float)-1.0f, (float)-0.03f));
        PartDefinition body = rootz.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.0f, (float)-10.5f));
        PartDefinition chest = body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 18).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)12.0f));
        PartDefinition leftfrontleg = rootz.addOrReplaceChild("leftfrontleg", CubeListBuilder.create().texOffs(34, 31).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.05f)), PartPose.offset((float)-2.5f, (float)-4.0f, (float)-8.0f));
        PartDefinition rightfrontleg = rootz.addOrReplaceChild("rightfrontleg", CubeListBuilder.create().texOffs(0, 35).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.05f)), PartPose.offset((float)2.5f, (float)-4.0f, (float)-8.0f));
        PartDefinition righthindleg = rootz.addOrReplaceChild("righthindleg", CubeListBuilder.create().texOffs(12, 35).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.05f)), PartPose.offset((float)2.5f, (float)-4.0f, (float)0.0f));
        PartDefinition lefthindleg = rootz.addOrReplaceChild("lefthindleg", CubeListBuilder.create().texOffs(24, 40).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.05f)), PartPose.offset((float)-2.5f, (float)-4.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T p_368486_, float pos, float speed, float ageInTicks, float p_102622_, float p_102623_) {
        this.rootz.getAllParts().forEach(ModelPart::resetPose);
        T mob = p_368486_;
        if (((ModMob)((Object)mob)).getBehaviorType() == 1) {
            this.animate(((ModMob)((Object)mob)).threatened, MobAnimations.threathened, ageInTicks, 1.0f);
            this.defaultAnimations((ModMob)((Object)mob), ageInTicks);
            if (((ModMob)((Object)p_368486_)).walkAnimation.speed() > 0.002f && ((ModMob)((Object)p_368486_)).walkAnimation.speed() < 10.0f) {
                if (p_368486_.isBaby()) {
                    this.animateWalk(MobAnimations.walk, pos, speed, 2.0f, 7.5f);
                } else {
                    this.animateWalk(MobAnimations.walk, pos, speed, 4.0f, 7.5f);
                }
            }
        } else if (((ModMob)((Object)mob)).getBehaviorType() == 4) {
            this.animate(((ModMob)((Object)mob)).sitDown, MobAnimations.sitDown, ageInTicks, 1.0f);
            this.animate(((ModMob)((Object)mob)).sitting, MobAnimations.sitting, ageInTicks, 1.0f);
            this.defaultAnimations((ModMob)((Object)mob), ageInTicks);
        } else if (((ModMob)((Object)p_368486_)).walkAnimation.speed() > 0.002f && ((ModMob)((Object)p_368486_)).walkAnimation.speed() < 10.0f) {
            if (p_368486_.isBaby()) {
                this.animateWalk(MobAnimations.walk, pos, speed, 2.0f, 7.5f);
            } else {
                this.animateWalk(MobAnimations.walk, pos, speed, 4.0f, 7.5f);
            }
        } else {
            this.animate(((ModMob)((Object)mob)).idle, MobAnimations.standing, ageInTicks, 1.0f);
            this.defaultAnimations((ModMob)((Object)mob), ageInTicks);
        }
    }

    public void defaultAnimations(ModMob mob, float ageInTicks) {
        this.animate(mob.panting, MobAnimations.panting, ageInTicks, 1.0f);
        this.animate(mob.tail, MobAnimations.tail, ageInTicks, 1.0f);
        this.animate(mob.sniffing, MobAnimations.sniffing, ageInTicks, 1.0f);
        this.animate(mob.rightEar1, MobAnimations.rightear1, ageInTicks, 1.0f);
        this.animate(mob.rightEar2, MobAnimations.rightear2, ageInTicks, 1.0f);
        this.animate(mob.leftEar1, MobAnimations.leftear1, ageInTicks, 1.0f);
        this.animate(mob.leftEar2, MobAnimations.leftear2, ageInTicks, 1.0f);
        this.animate(mob.wink, MobAnimations.wink, ageInTicks, 1.0f);
        this.animate(mob.tired, MobAnimations.tired, ageInTicks, 1.0f);
        this.animate(mob.lookLeft, MobAnimations.lookleft, ageInTicks, 1.0f);
        this.animate(mob.lookRight, MobAnimations.lookright, ageInTicks, 1.0f);
        this.animate(mob.lookUp, MobAnimations.lookup, ageInTicks, 1.0f);
        this.animate(mob.lookDown, MobAnimations.lookdown, ageInTicks, 1.0f);
        this.animate(mob.headTiltLeft, MobAnimations.headtiltleft, ageInTicks, 1.0f);
        this.animate(mob.headTiltRight, MobAnimations.headtiltright, ageInTicks, 1.0f);
    }

    public void animate(AnimationState p_233386_, AnimationDefinition p_233387_, float p_233388_, float p_233389_) {
        p_233386_.updateTime(p_233388_, p_233389_);
        p_233386_.ifStarted(p_233392_ -> ModMobModel.animate(this, p_233387_, p_233392_.getAccumulatedTime(), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    public void animateWalk(AnimationDefinition p_268159_, float p_268057_, float p_268347_, float p_268138_, float p_268165_) {
        long i = (long)(p_268057_ * 50.0f * p_268138_);
        float f = Math.min(p_268347_ * p_268165_, 1.0f);
        ModMobModel.animate(this, p_268159_, i, f, ANIMATION_VECTOR_CACHE);
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.looping() ? f % p_232317_.lengthInSeconds() : f;
    }

    public Optional<ModelPart> getAnyDescendantWithName(String p_233394_) {
        return p_233394_.equals("rootz") ? Optional.of(this.rootz) : this.rootz.getAllParts().filter(p_233400_ -> p_233400_.hasChild(p_233394_)).findFirst().map(p_233397_ -> p_233397_.getChild(p_233394_));
    }

    public static void animate(ModMobModel<?> p_232320_, AnimationDefinition p_232321_, long p_232322_, float p_232323_, Vector3f p_253861_) {
        float f = ModMobModel.getElapsedSeconds(p_232321_, p_232322_);
        for (Map.Entry entry : p_232321_.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = p_232320_.getAnyDescendantWithName((String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = j != i ? Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.interpolation().apply(p_253861_, f2, akeyframe, i, j, p_232323_);
                p_288241_.target().apply(p_232330_, p_253861_);
            }));
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.rootz);
    }
}

