/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.redpanda.mob.goals;

import aquariusplayz.animalgarden.redpanda.mob.ModMob;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ModTemptGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.forNonCombat().range(10.0).ignoreLineOfSight();
    private final TargetingConditions targetingConditions;
    protected final ModMob mob;
    private final double speedModifier;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    @Nullable
    protected Player player;
    private int calmDown;
    private boolean isRunning;
    private final Predicate<ItemStack> items;
    private final boolean canScare;

    public ModTemptGoal(ModMob p_25939_, double p_25940_, Predicate<ItemStack> p_329244_, boolean p_25942_) {
        this.mob = p_25939_;
        this.speedModifier = p_25940_;
        this.items = p_329244_;
        this.canScare = p_25942_;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMP_TARGETING.copy().selector(this::shouldFollow);
    }

    public boolean canUse() {
        if (this.mob.getBehaviorType() == 1 && this.mob.standingTick > 300 || this.mob.getBehaviorType() == 4 || this.mob.getBehaviorType() == 6) {
            return false;
        }
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.player = this.mob.level().getNearestPlayer(this.targetingConditions, (LivingEntity)this.mob);
        return this.player != null;
    }

    private boolean shouldFollow(LivingEntity p_148139_) {
        return this.items.test(p_148139_.getMainHandItem()) || this.items.test(p_148139_.getOffhandItem());
    }

    public boolean canContinueToUse() {
        if (this.mob.getBehaviorType() == 1 && this.mob.standingTick > 300 || this.mob.getBehaviorType() == 4 || this.mob.getBehaviorType() == 6) {
            return false;
        }
        if (this.canScare()) {
            if (this.mob.distanceToSqr((Entity)this.player) < 36.0) {
                if (this.player.distanceToSqr(this.px, this.py, this.pz) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.player.getXRot() - this.pRotX) > 5.0 || Math.abs((double)this.player.getYRot() - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = this.player.getX();
                this.py = this.player.getY();
                this.pz = this.player.getZ();
            }
            this.pRotX = this.player.getXRot();
            this.pRotY = this.player.getYRot();
        }
        return this.canUse();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    public void start() {
        this.px = this.player.getX();
        this.py = this.player.getY();
        this.pz = this.player.getZ();
        this.isRunning = true;
    }

    public void stop() {
        this.player = null;
        this.mob.getNavigation().stop();
        this.calmDown = ModTemptGoal.reducedTickDelay((int)100);
        this.isRunning = false;
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.player, (float)(this.mob.getMaxHeadYRot() + 20), (float)this.mob.getMaxHeadXRot());
        if (this.mob.distanceToSqr((Entity)this.player) < 6.25) {
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.player, this.speedModifier);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

