/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.redpanda.mob;

import aquariusplayz.animalgarden.redpanda.Registrations;
import aquariusplayz.animalgarden.redpanda.mob.ModAnimationState;
import aquariusplayz.animalgarden.redpanda.mob.goals.ModFollowOwnerGoal;
import aquariusplayz.animalgarden.redpanda.mob.goals.ModTemptGoal;
import aquariusplayz.animalgarden.redpanda.mob.goals.ModWaterAvoidingRandomStrollGoal;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ModMob
extends TamableAnimal
implements NeutralMob {
    public final ModAnimationState lookLeft = new ModAnimationState();
    public final ModAnimationState lookRight = new ModAnimationState();
    public final ModAnimationState lookUp = new ModAnimationState();
    public final ModAnimationState lookDown = new ModAnimationState();
    public final ModAnimationState wink = new ModAnimationState();
    public final ModAnimationState eat = new ModAnimationState();
    public final ModAnimationState tired = new ModAnimationState();
    public final ModAnimationState headTiltLeft = new ModAnimationState();
    public final ModAnimationState headTiltRight = new ModAnimationState();
    public final ModAnimationState sniffing = new ModAnimationState();
    public final ModAnimationState tail = new ModAnimationState();
    public final ModAnimationState rightEar1 = new ModAnimationState();
    public final ModAnimationState leftEar1 = new ModAnimationState();
    public final ModAnimationState rightEar2 = new ModAnimationState();
    public final ModAnimationState leftEar2 = new ModAnimationState();
    public final ModAnimationState panting = new ModAnimationState();
    public final ModAnimationState sitDown = new ModAnimationState();
    public final ModAnimationState sitting = new ModAnimationState();
    public final ModAnimationState threatened = new ModAnimationState();
    public final ModAnimationState running = new ModAnimationState();
    public final ModAnimationState idle = new ModAnimationState();
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    private static final EntityDataAccessor<Integer> BEHAVIOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int standingTick;

    public ModMob(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(BEHAVIOR, (Object)0);
        p_335317_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public int getBehaviorType() {
        return (Integer)this.entityData.get(BEHAVIOR);
    }

    private void setBehaviorType(int p_30398_) {
        this.entityData.set(BEHAVIOR, (Object)p_30398_);
    }

    public void addAdditionalSaveData(ValueOutput p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        this.addPersistentAngerSaveData(p_29422_);
        p_29422_.putInt("BehaviorType", this.getBehaviorType());
    }

    public void readAdditionalSaveData(ValueInput p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.readPersistentAngerSaveData(this.level(), p_29402_);
        this.setBehaviorType(p_29402_.getIntOr("BehaviorType", 0));
    }

    protected boolean canFlyToOwner() {
        return this.getBehaviorType() == 6;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.TEMPT_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new ModFollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(3, (Goal)new ModTemptGoal((PathfinderMob)this, 1.25, p_332367_ -> this.isFood((ItemStack)p_332367_), false));
        this.goalSelector.addGoal(5, (Goal)new ModWaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, (arg_0, arg_1) -> ((ModMob)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void defaultAnimations() {
        int a;
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.panting, 6.0f)) {
            this.panting.start(this.tickCount);
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.sniffing, 0.75f)) {
            this.sniffing.start(this.tickCount);
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.tail, 5.0f)) {
            this.tail.start(this.tickCount);
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.rightEar1, 3.0f) && this.animationEnded(this.rightEar2, 3.0f)) {
            a = this.level().random.nextInt(2);
            if (a == 0) {
                this.rightEar1.start(this.tickCount);
            } else {
                this.rightEar2.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.leftEar1, 3.0f) && this.animationEnded(this.leftEar2, 3.0f)) {
            a = this.level().random.nextInt(2);
            if (a == 0) {
                this.leftEar1.start(this.tickCount);
            } else {
                this.leftEar2.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.wink, 0.5f) && this.animationEnded(this.tired, 8.0f)) {
            a = this.level().random.nextInt(2);
            if (a == 0) {
                this.wink.start(this.tickCount);
            } else {
                this.tired.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.eat, 3.0f) && this.animationEnded(this.lookLeft, 4.0f) && this.animationEnded(this.lookRight, 4.0f) && this.animationEnded(this.lookUp, 4.0f) && this.animationEnded(this.lookDown, 4.0f)) {
            a = this.level().random.nextInt(4);
            if (a == 0) {
                this.lookLeft.start(this.tickCount);
            } else if (a == 1) {
                this.lookRight.start(this.tickCount);
            } else if (a == 2) {
                this.lookUp.start(this.tickCount);
            } else {
                this.lookDown.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.headTiltLeft, 3.0f) && this.animationEnded(this.headTiltRight, 3.0f)) {
            a = this.level().random.nextInt(2);
            if (a == 0) {
                this.headTiltLeft.start(this.tickCount);
            } else {
                this.headTiltRight.start(this.tickCount);
            }
        }
    }

    public void stopDefaultAnimations() {
        this.sitDown.stop();
        this.sitting.stop();
        this.panting.stop();
        this.tail.stop();
        this.sniffing.stop();
        this.rightEar1.stop();
        this.rightEar2.stop();
        this.leftEar1.stop();
        this.leftEar2.stop();
        this.wink.stop();
        this.tired.stop();
        this.lookLeft.stop();
        this.lookRight.stop();
        this.lookUp.stop();
        this.lookDown.stop();
        this.headTiltLeft.stop();
        this.headTiltRight.stop();
    }

    public void aiStep() {
        super.aiStep();
        if (!this.isTame()) {
            if (this.standingTick > 0) {
                --this.standingTick;
            }
            if (this.standingTick <= 300 && this.getBehaviorType() == 1) {
                this.setBehaviorType(0);
                this.threatened.stop();
            }
            if (this.getBehaviorType() == 0 && this.level().hasNearbyAlivePlayer(this.getX(), this.getY(), this.getZ(), 15.0) && this.standingTick <= 0) {
                this.standingTick = 400;
                this.setBehaviorType(1);
                this.threatened.start(this.tickCount);
            }
        }
        if (this.level().isClientSide()) {
            if (this.getBehaviorType() == 1) {
                this.defaultAnimations();
            } else if (this.getBehaviorType() == 4) {
                this.defaultAnimations();
                if (!this.sitting.isStarted() && !this.sitDown.isStarted()) {
                    this.sitDown.start(this.tickCount);
                } else if (!this.sitting.isStarted() && this.sitDown.isStarted() && this.animationEnded(this.sitDown, 0.5f)) {
                    this.sitting.start(this.tickCount);
                    this.sitDown.stop();
                }
            } else {
                if (this.sitting.isStarted() || this.sitDown.isStarted()) {
                    this.sitDown.stop();
                    this.sitting.stop();
                }
                if (this.walkAnimation.isMoving()) {
                    this.stopDefaultAnimations();
                } else if (!this.idle.isStarted()) {
                    this.idle.start(this.tickCount);
                } else if (this.idle.isStarted() && !this.walkAnimation.isMoving()) {
                    this.defaultAnimations();
                }
            }
        } else {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.tickCount) > animLength * 1000.0f;
    }

    public boolean hurtServer(ServerLevel p_361743_, DamageSource p_361865_, float p_365677_) {
        if (super.hurtServer(p_361743_, p_361865_, p_365677_)) {
            if (this.isTame() && (this.getBehaviorType() == 1 || this.getBehaviorType() == 4)) {
                this.setBehaviorType(6);
            }
            return true;
        }
        return false;
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(0.5);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public boolean wantsToAttack(LivingEntity p_30389_, LivingEntity p_30390_) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (p_30389_ instanceof Creeper || p_30389_ instanceof Ghast || p_30389_ instanceof ArmorStand) {
            return false;
        }
        if (p_30389_ instanceof ModMob) {
            ModMob mob = (ModMob)p_30389_;
            return !mob.isTame() || mob.getOwner() != p_30390_;
        }
        if (p_30389_ instanceof Player) {
            Player player1;
            Player player = (Player)p_30389_;
            if (p_30390_ instanceof Player && !(player1 = (Player)p_30390_).canHarmPlayer(player)) {
                return false;
            }
        }
        if (p_30389_ instanceof AbstractHorse && (abstracthorse = (AbstractHorse)p_30389_).isTamed()) {
            return false;
        }
        return !(p_30389_ instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)p_30389_).isTame();
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return (SoundEvent)Registrations.IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_29437_) {
        return (SoundEvent)Registrations.IDLE.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)Registrations.IDLE.get();
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(Items.BAMBOO);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        ModMob mob = (ModMob)this.getType().create((Level)p_148993_, EntitySpawnReason.BREEDING);
        if (this.isTame()) {
            mob.setOwnerReference(this.getOwnerReference());
            mob.setTame(true, true);
        }
        return mob;
    }

    public void tryToTame(Player p_336244_) {
        if (this.random.nextInt(3) == 0) {
            this.setBehaviorType(4);
            this.tame(p_336244_);
            this.navigation.stop();
            this.setTarget(null);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(25.0);
            this.setHealth(25.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8.0);
        }
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        if (this.isTame()) {
            if (this.isFood(itemstack)) {
                this.usePlayerItem(p_30412_, p_30413_, itemstack);
                FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                this.heal(2.0f * f);
                if (this.animationEnded(this.eat, 3.0f)) {
                    this.eat.start(this.tickCount);
                }
                return super.mobInteract(p_30412_, p_30413_);
            }
            InteractionResult interactionresult = super.mobInteract(p_30412_, p_30413_);
            if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)p_30412_)) {
                if (this.getBehaviorType() == 0) {
                    this.setBehaviorType(4);
                } else if (this.getBehaviorType() == 4) {
                    this.setBehaviorType(6);
                    this.playSound((SoundEvent)Registrations.IDLE.get(), 5.0f, 0.75f);
                } else {
                    this.setBehaviorType(0);
                }
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (!this.level().isClientSide() && this.isFood(itemstack)) {
            itemstack.consume(1, (LivingEntity)p_30412_);
            this.tryToTame(p_30412_);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_30412_, p_30413_);
    }
}

