/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.redpanda.mob;

import aquariusplayz.animalgarden.redpanda.mob.MobAnimations;
import aquariusplayz.animalgarden.redpanda.mob.ModMob;
import aquariusplayz.animalgarden.redpanda.mob.ModMobRenderState;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public class ModMobModel
extends EntityModel<ModMobRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_redpanda", (String)"redpanda"), "main");
    public static final ModelLayerLocation BABY_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_redpanda", (String)"redpanda_baby"), "main");
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(Set.of("head"));
    private final ModelPart rootz;
    private final ModelPart head;
    private final ModelPart rightear;
    private final ModelPart leftear;
    private final ModelPart mouth;
    private final ModelPart nose;
    private final ModelPart righteye;
    private final ModelPart lefteyeball;
    private final ModelPart lefteye;
    private final ModelPart righteyeball;
    private final ModelPart body;
    private final ModelPart chest;
    private final ModelPart tail;
    private final ModelPart leftfrontleg;
    private final ModelPart rightfrontleg;
    private final ModelPart righthindleg;
    private final ModelPart lefthindleg;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public ModMobModel(ModelPart root) {
        super(root);
        this.rootz = root.getChild("rootz");
        this.head = this.rootz.getChild("head");
        this.rightear = this.head.getChild("rightear");
        this.leftear = this.head.getChild("leftear");
        this.mouth = this.head.getChild("mouth");
        this.nose = this.head.getChild("nose");
        this.righteye = this.head.getChild("righteye");
        this.lefteyeball = this.righteye.getChild("lefteyeball");
        this.lefteye = this.head.getChild("lefteye");
        this.righteyeball = this.lefteye.getChild("righteyeball");
        this.body = this.rootz.getChild("body");
        this.chest = this.body.getChild("chest");
        this.tail = this.body.getChild("tail");
        this.leftfrontleg = this.rootz.getChild("leftfrontleg");
        this.rightfrontleg = this.rootz.getChild("rightfrontleg");
        this.righthindleg = this.rootz.getChild("righthindleg");
        this.lefthindleg = this.rootz.getChild("lefthindleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rootz = partdefinition.addOrReplaceChild("rootz", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)5.5f));
        PartDefinition head = rootz.addOrReplaceChild("head", CubeListBuilder.create().texOffs(34, 18).addBox(-5.0f, -4.0f, -6.0f, 10.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(36, 40).addBox(-2.0f, 0.0f, -8.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-10.5f));
        PartDefinition rightear = head.addOrReplaceChild("rightear", CubeListBuilder.create().texOffs(42, 12).addBox(-3.0f, -2.0f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(20, 44).addBox(0.0f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-4.0f, (float)-4.5f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create().texOffs(36, 44).addBox(-1.0f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 44).addBox(0.0f, -2.0f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-4.0f, (float)-4.5f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(42, 0).addBox(-2.0f, 1.0f, -3.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-5.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(42, 8).addBox(-1.0f, -1.65f, -1.65f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)1.35f, (float)-6.65f));
        PartDefinition righteye = head.addOrReplaceChild("righteye", CubeListBuilder.create().texOffs(14, 44).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)0.0f, (float)-5.51f));
        PartDefinition lefteyeball = righteye.addOrReplaceChild("lefteyeball", CubeListBuilder.create().texOffs(42, 3).addBox(-1.5f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.51f)), PartPose.offset((float)0.5f, (float)-1.0f, (float)-0.03f));
        PartDefinition lefteye = head.addOrReplaceChild("lefteye", CubeListBuilder.create().texOffs(8, 44).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.0f, (float)-5.51f));
        PartDefinition righteyeball = lefteye.addOrReplaceChild("righteyeball", CubeListBuilder.create().texOffs(24, 35).addBox(-0.5f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.51f)), PartPose.offset((float)-0.5f, (float)-1.0f, (float)-0.03f));
        PartDefinition body = rootz.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.0f, (float)-10.5f));
        PartDefinition chest = body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 18).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)12.0f));
        PartDefinition leftfrontleg = rootz.addOrReplaceChild("leftfrontleg", CubeListBuilder.create().texOffs(34, 31).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.05f)), PartPose.offset((float)-2.5f, (float)-4.0f, (float)-8.0f));
        PartDefinition rightfrontleg = rootz.addOrReplaceChild("rightfrontleg", CubeListBuilder.create().texOffs(0, 35).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.05f)), PartPose.offset((float)2.5f, (float)-4.0f, (float)-8.0f));
        PartDefinition righthindleg = rootz.addOrReplaceChild("righthindleg", CubeListBuilder.create().texOffs(12, 35).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.05f)), PartPose.offset((float)2.5f, (float)-4.0f, (float)0.0f));
        PartDefinition lefthindleg = rootz.addOrReplaceChild("lefthindleg", CubeListBuilder.create().texOffs(24, 40).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.05f)), PartPose.offset((float)-2.5f, (float)-4.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(ModMobRenderState p_368486_) {
        super.setupAnim((Object)p_368486_);
        ModMob mob = p_368486_.entity;
        if (mob.getBehaviorType() == 1) {
            this.animate(mob.threatened, MobAnimations.threathened, p_368486_.ageInTicks, 1.0f);
            this.defaultAnimations(mob, p_368486_);
            if (p_368486_.walkAnimationSpeed > 0.002f && p_368486_.walkAnimationSpeed < 10.0f) {
                if (p_368486_.isBaby) {
                    this.animateWalk(MobAnimations.walk, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 2.0f, 7.5f);
                } else {
                    this.animateWalk(MobAnimations.walk, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 4.0f, 7.5f);
                }
            }
        } else if (mob.getBehaviorType() == 4) {
            this.animate(mob.sitDown, MobAnimations.sitDown, p_368486_.ageInTicks, 1.0f);
            this.animate(mob.sitting, MobAnimations.sitting, p_368486_.ageInTicks, 1.0f);
            this.defaultAnimations(mob, p_368486_);
        } else if (p_368486_.walkAnimationSpeed > 0.002f && p_368486_.walkAnimationSpeed < 10.0f) {
            if (p_368486_.isBaby) {
                this.animateWalk(MobAnimations.walk, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 2.0f, 7.5f);
            } else {
                this.animateWalk(MobAnimations.walk, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 4.0f, 7.5f);
            }
        } else {
            this.animate(mob.idle, MobAnimations.standing, p_368486_.ageInTicks, 1.0f);
            this.defaultAnimations(mob, p_368486_);
        }
    }

    public void defaultAnimations(ModMob mob, ModMobRenderState p_368486_) {
        this.animate(mob.panting, MobAnimations.panting, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.tail, MobAnimations.tail, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.eat, MobAnimations.eat, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.sniffing, MobAnimations.sniffing, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.rightEar1, MobAnimations.rightear1, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.rightEar2, MobAnimations.rightear2, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.leftEar1, MobAnimations.leftear1, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.leftEar2, MobAnimations.leftear2, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.wink, MobAnimations.wink, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.tired, MobAnimations.tired, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookLeft, MobAnimations.lookleft, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookRight, MobAnimations.lookright, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookUp, MobAnimations.lookup, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.lookDown, MobAnimations.lookdown, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headTiltLeft, MobAnimations.headtiltleft, p_368486_.ageInTicks, 1.0f);
        this.animate(mob.headTiltRight, MobAnimations.headtiltright, p_368486_.ageInTicks, 1.0f);
    }

    protected void animate(AnimationState p_361867_, AnimationDefinition p_365477_, float p_361961_) {
        this.animate(p_361867_, p_365477_, p_361961_, 1.0f);
    }

    protected void animateWalk(AnimationDefinition p_363127_, float p_364817_, float p_364163_, float p_365350_, float p_365167_) {
        long i = (long)(p_364817_ * 50.0f * p_365350_);
        float f = Math.min(p_364163_ * p_365167_, 1.0f);
        ModMobModel.animate((Model)this, p_363127_, i, f, ANIMATION_VECTOR_CACHE);
    }

    protected void animate(AnimationState p_368871_, AnimationDefinition p_365491_, float p_363110_, float p_368202_) {
        p_368871_.ifStarted(p_368242_ -> ModMobModel.animate((Model)this, p_365491_, (long)((float)p_368242_.getTimeInMillis(p_363110_) * p_368202_), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    protected void applyStatic(AnimationDefinition p_369884_) {
        ModMobModel.animate((Model)this, p_369884_, 0L, 1.0f, ANIMATION_VECTOR_CACHE);
    }

    public static Optional<ModelPart> getAnyDescendantWithName(Model p_362391_, String p_363872_) {
        Stream stream = p_362391_.root().getAllParts().stream();
        return p_363872_.equals("root") ? Optional.of(p_362391_.root()) : stream.filter(p_364767_ -> p_364767_.hasChild(p_363872_)).findFirst().map(p_366385_ -> p_366385_.getChild(p_363872_));
    }

    public static void animate(Model p_362391_, AnimationDefinition p_232321_, long p_232322_, float p_232323_, Vector3f p_253861_) {
        float f = ModMobModel.getElapsedSeconds(p_232321_, p_232322_);
        for (Map.Entry entry : p_232321_.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = ModMobModel.getAnyDescendantWithName(p_362391_, (String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = j != i ? Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.interpolation().apply(p_253861_, f2, akeyframe, i, j, p_232323_);
                p_288241_.target().apply(p_232330_, p_253861_);
            }));
        }
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.looping() ? f % p_232317_.lengthInSeconds() : f;
    }
}

