/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.redpanda.mob.goals;

import aquariusplayz.animalgarden.redpanda.mob.ModMob;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class ModFollowOwnerGoal
extends Goal {
    private final ModMob mob;
    @Nullable
    private LivingEntity owner;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public ModFollowOwnerGoal(ModMob p_25294_, double p_25295_, float p_25296_, float p_25297_) {
        this.mob = p_25294_;
        this.speedModifier = p_25295_;
        this.navigation = p_25294_.getNavigation();
        this.startDistance = p_25296_;
        this.stopDistance = p_25297_;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(p_25294_.getNavigation() instanceof GroundPathNavigation) && !(p_25294_.getNavigation() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean canUse() {
        if (this.mob.getBehaviorType() != 6) {
            return false;
        }
        LivingEntity livingentity = this.mob.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (this.mob.unableToMoveToOwner()) {
            return false;
        }
        if (this.mob.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.mob.getBehaviorType() != 6) {
            return false;
        }
        if (this.navigation.isDone()) {
            return false;
        }
        return this.mob.unableToMoveToOwner() ? false : !(this.mob.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
        this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        boolean flag = this.mob.shouldTryTeleportToOwner();
        if (!flag) {
            this.mob.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.mob.getMaxHeadXRot());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (flag) {
                this.mob.tryToTeleportToOwner();
            } else {
                this.navigation.moveTo((Entity)this.owner, this.speedModifier);
            }
        }
    }
}

