/*
 * Decompiled with CFR 0.152.
 */
package com.voicechatz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.JDAInfo;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VoiceChatZ
extends JavaPlugin
implements Listener {
    private JDA jda;
    private String discordToken;
    private String guildId;
    private String categoryId;
    private String lobbyChannelId;
    private double proximityDistance;
    private Map<UUID, String> playerDiscordIds;
    private Map<String, Set<UUID>> proximityGroups;
    private Map<String, String> proximityChannels;
    private boolean proximityChannelLock = false;
    private long lastProximityCheck = 0L;
    private long lastChannelOperation = 0L;
    private static final long CHANNEL_OP_COOLDOWN = 3000L;

    public void onEnable() {
        this.getLogger().info("JDA Version: " + JDAInfo.VERSION);
        this.saveDefaultConfig();
        this.loadConfig();
        this.playerDiscordIds = new ConcurrentHashMap<UUID, String>();
        this.proximityGroups = new ConcurrentHashMap<String, Set<UUID>>();
        this.proximityChannels = new ConcurrentHashMap<String, String>();
        this.loadPlayerLinks();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("voicechattest").setExecutor((CommandExecutor)new VoiceChatTestCommand());
        this.getCommand("linkdiscord").setExecutor((CommandExecutor)new LinkDiscordCommand());
        try {
            this.jda = JDABuilder.createDefault(this.discordToken).enableIntents(GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_VOICE_STATES).addEventListeners(new DiscordEventListener()).build();
            this.jda.awaitReady();
            this.setupDiscordEnvironment();
            this.getLogger().info("Connected to Discord successfully!");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to connect to Discord: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, this::checkAllPlayersProximity, 20L, 20L);
        this.getLogger().info("VoiceChatZ has been enabled!");
    }

    public void onDisable() {
        this.cleanupVoiceChannels();
        if (this.jda != null) {
            this.jda.shutdown();
        }
        this.getLogger().info("VoiceChatZ has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.discordToken = config.getString("discord.token", "YOUR_TOKEN_HERE");
        this.guildId = config.getString("discord.guild_id", "YOUR_GUILD_ID_HERE");
        this.categoryId = config.getString("discord.category_id", "");
        this.lobbyChannelId = config.getString("discord.lobby_channel_id", "");
        this.proximityDistance = config.getDouble("proximity_distance", 5.0);
        if (this.discordToken.equals("YOUR_TOKEN_HERE")) {
            this.getLogger().warning("Please set your Discord bot token in the config.yml!");
        }
        if (this.guildId.equals("YOUR_GUILD_ID_HERE")) {
            this.getLogger().warning("Please set your Discord guild ID in the config.yml!");
        }
        this.saveConfig();
    }

    private void setupDiscordEnvironment() {
        VoiceChannel lobbyChannel;
        FileConfiguration config;
        Category category;
        Guild guild = this.jda.getGuildById(this.guildId);
        if (guild == null) {
            this.getLogger().severe("Could not find Discord server with ID: " + this.guildId);
            return;
        }
        if (this.categoryId.isEmpty()) {
            category = (Category)guild.createCategory("VoiceChatZ").complete();
            this.categoryId = category.getId();
            config = this.getConfig();
            config.set("discord.category_id", (Object)this.categoryId);
            this.saveConfig();
            this.getLogger().info("Created VoiceChatZ category with ID: " + this.categoryId);
        } else {
            category = guild.getCategoryById(this.categoryId);
            if (category == null) {
                category = (Category)guild.createCategory("VoiceChatZ").complete();
                this.categoryId = category.getId();
                config = this.getConfig();
                config.set("discord.category_id", (Object)this.categoryId);
                this.saveConfig();
                this.getLogger().info("Re-created VoiceChatZ category with ID: " + this.categoryId);
            }
        }
        if (this.lobbyChannelId.isEmpty()) {
            lobbyChannel = (VoiceChannel)category.createVoiceChannel("VoiceChatZ-Lobby").complete();
            this.lobbyChannelId = lobbyChannel.getId();
            lobbyChannel.getManager().putPermissionOverride((IPermissionHolder)guild.getPublicRole(), Arrays.asList(Permission.VOICE_CONNECT), Arrays.asList(Permission.VOICE_SPEAK, Permission.VOICE_USE_VAD)).queue(null, error -> this.getLogger().warning("Failed to set lobby permissions: " + error.getMessage()));
            FileConfiguration config2 = this.getConfig();
            config2.set("discord.lobby_channel_id", (Object)this.lobbyChannelId);
            this.saveConfig();
            this.getLogger().info("Created VoiceChatZ lobby channel with ID: " + this.lobbyChannelId);
        } else {
            lobbyChannel = guild.getVoiceChannelById(this.lobbyChannelId);
            if (lobbyChannel == null) {
                lobbyChannel = (VoiceChannel)category.createVoiceChannel("VoiceChatZ-Lobby").complete();
                this.lobbyChannelId = lobbyChannel.getId();
                lobbyChannel.getManager().putPermissionOverride((IPermissionHolder)guild.getPublicRole(), Arrays.asList(Permission.VOICE_CONNECT), Arrays.asList(Permission.VOICE_SPEAK, Permission.VOICE_USE_VAD)).complete();
                FileConfiguration config3 = this.getConfig();
                config3.set("discord.lobby_channel_id", (Object)this.lobbyChannelId);
                this.saveConfig();
                this.getLogger().info("Re-created VoiceChatZ lobby channel with ID: " + this.lobbyChannelId);
            } else {
                lobbyChannel.getManager().putPermissionOverride((IPermissionHolder)guild.getPublicRole(), Arrays.asList(Permission.VOICE_CONNECT), Arrays.asList(Permission.VOICE_SPEAK, Permission.VOICE_USE_VAD)).complete();
                this.getLogger().info("Updated permissions for existing lobby channel");
            }
        }
        this.cleanupVoiceChannels();
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerUuid = player.getUniqueId();
        if (!this.playerDiscordIds.containsKey(playerUuid)) {
            return;
        }
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, this::checkAllPlayersProximity);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerUuid = player.getUniqueId();
        if (this.playerDiscordIds.containsKey(playerUuid)) {
            player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fYour Discord account is already linked!");
            player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fJoin the VoiceChatZ-Lobby voice channel to use proximity voice chat.");
            Guild guild = this.jda.getGuildById(this.guildId);
            if (guild != null) {
                String discordId = this.playerDiscordIds.get(playerUuid);
                guild.retrieveMemberById(discordId).queue(member -> {
                    if (member != null && member.getVoiceState().inVoiceChannel() && member.getVoiceState().getChannel().getId().equals(this.lobbyChannelId)) {
                        member.mute(true).queue(success -> this.getLogger().info("Server muted " + member.getUser().getName() + " in lobby on join"), error -> this.getLogger().warning("Failed to server mute member on join: " + error.getMessage()));
                    }
                });
            }
        } else {
            player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fUse /linkdiscord <your_discord_id> to enable proximity voice chat!");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerUuid = event.getPlayer().getUniqueId();
        for (Map.Entry<String, Set<UUID>> entry : new HashMap<String, Set<UUID>>(this.proximityGroups).entrySet()) {
            String groupId = entry.getKey();
            Set<UUID> members = entry.getValue();
            if (!members.contains(playerUuid)) continue;
            this.removePlayerFromGroup(playerUuid, groupId);
        }
        if (this.playerDiscordIds.containsKey(playerUuid)) {
            VoiceChannel lobbyChannel;
            Member member;
            String discordId = this.playerDiscordIds.get(playerUuid);
            Guild guild = this.jda.getGuildById(this.guildId);
            if (guild != null && (member = guild.getMemberById(discordId)) != null && member.getVoiceState().inVoiceChannel() && !member.getVoiceState().getChannel().getId().equals(this.lobbyChannelId) && (lobbyChannel = guild.getVoiceChannelById(this.lobbyChannelId)) != null) {
                guild.moveVoiceMember(member, lobbyChannel).queue();
            }
        }
    }

    private void loadPlayerLinks() {
        if (this.getConfig().contains("player_links")) {
            ConfigurationSection linksSection = this.getConfig().getConfigurationSection("player_links");
            if (linksSection != null) {
                for (String uuidString : linksSection.getKeys(false)) {
                    try {
                        UUID playerUuid = UUID.fromString(uuidString);
                        String discordId = linksSection.getString(uuidString);
                        if (discordId == null || discordId.isEmpty()) continue;
                        this.playerDiscordIds.put(playerUuid, discordId);
                        this.getLogger().info("Loaded Discord link for player: " + uuidString);
                    }
                    catch (IllegalArgumentException e) {
                        this.getLogger().warning("Invalid UUID in config: " + uuidString);
                    }
                }
            }
            this.getLogger().info("Loaded " + this.playerDiscordIds.size() + " player-Discord links");
        }
    }

    public void checkAllPlayersProximity() {
        ArrayList onlinePlayers = new ArrayList(this.getServer().getOnlinePlayers());
        List linkedPlayers = onlinePlayers.stream().filter(p -> this.playerDiscordIds.containsKey(p.getUniqueId())).collect(Collectors.toList());
        if (linkedPlayers.size() < 2) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastProximityCheck < 2000L) {
            return;
        }
        this.lastProximityCheck = currentTime;
        HashSet<UUID> processedPlayers = new HashSet<UUID>();
        ConcurrentHashMap<String, Set<UUID>> newProximityGroups = new ConcurrentHashMap<String, Set<UUID>>();
        for (Player player : linkedPlayers) {
            Object otherPlayer2;
            UUID playerUuid = player.getUniqueId();
            if (processedPlayers.contains(playerUuid)) continue;
            HashSet<UUID> newGroup = new HashSet<UUID>();
            newGroup.add(playerUuid);
            processedPlayers.add(playerUuid);
            for (Object otherPlayer2 : linkedPlayers) {
                double distance;
                UUID otherPlayerUuid = otherPlayer2.getUniqueId();
                if (otherPlayerUuid.equals(playerUuid) || processedPlayers.contains(otherPlayerUuid) || !player.getWorld().equals((Object)otherPlayer2.getWorld()) || !((distance = player.getLocation().distance(otherPlayer2.getLocation())) <= this.proximityDistance)) continue;
                boolean closeToAll = true;
                for (UUID memberUuid : newGroup) {
                    Player memberPlayer;
                    if (memberUuid.equals(otherPlayerUuid) || (memberPlayer = this.getServer().getPlayer(memberUuid)) == null) continue;
                    if (!memberPlayer.getWorld().equals((Object)otherPlayer2.getWorld())) {
                        closeToAll = false;
                        break;
                    }
                    double memberDistance = otherPlayer2.getLocation().distance(memberPlayer.getLocation());
                    if (!(memberDistance > this.proximityDistance)) continue;
                    closeToAll = false;
                    break;
                }
                if (!closeToAll) continue;
                newGroup.add(otherPlayerUuid);
                processedPlayers.add(otherPlayerUuid);
            }
            if (newGroup.size() <= 1) continue;
            boolean matchFound = false;
            otherPlayer2 = this.proximityGroups.entrySet().iterator();
            while (otherPlayer2.hasNext()) {
                Map.Entry entry = (Map.Entry)otherPlayer2.next();
                String existingGroupId = (String)entry.getKey();
                Set existingMembers = (Set)entry.getValue();
                HashSet intersection = new HashSet(existingMembers);
                intersection.retainAll(newGroup);
                if (intersection.isEmpty() || !((double)intersection.size() >= (double)existingMembers.size() * 0.75) || !((double)intersection.size() >= (double)newGroup.size() * 0.75)) continue;
                newProximityGroups.put(existingGroupId, newGroup);
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            String groupId = UUID.randomUUID().toString();
            newProximityGroups.put(groupId, newGroup);
            this.getLogger().info("Created new proximity group with " + newGroup.size() + " players");
        }
        if (!this.proximityChannelLock) {
            this.processGroupChanges(newProximityGroups);
        } else {
            this.getLogger().info("Skipping group processing - operations in progress");
        }
    }

    private void processGroupChanges(Map<String, Set<UUID>> newGroups) {
        this.proximityChannelLock = true;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastChannelOperation < 3000L) {
            this.proximityChannelLock = false;
            return;
        }
        this.lastChannelOperation = currentTime;
        Guild guild = this.jda.getGuildById(this.guildId);
        if (guild == null) {
            this.proximityChannelLock = false;
            return;
        }
        Category category = guild.getCategoryById(this.categoryId);
        if (category == null) {
            this.proximityChannelLock = false;
            return;
        }
        VoiceChannel lobbyChannel = guild.getVoiceChannelById(this.lobbyChannelId);
        if (lobbyChannel == null) {
            this.proximityChannelLock = false;
            return;
        }
        HashSet<String> groupsToDelete = new HashSet<String>(this.proximityGroups.keySet());
        groupsToDelete.removeAll(newGroups.keySet());
        if (!groupsToDelete.isEmpty()) {
            String groupId = (String)groupsToDelete.iterator().next();
            this.deleteProximityGroup(guild, lobbyChannel, groupId);
        } else {
            boolean operationDone = false;
            for (Map.Entry<String, Set<UUID>> entry : new HashMap<String, Set<UUID>>(newGroups).entrySet()) {
                String groupId = entry.getKey();
                Set<UUID> members = entry.getValue();
                if (this.proximityGroups.containsKey(groupId)) {
                    VoiceChannel channel;
                    Set<UUID> existingMembers = this.proximityGroups.get(groupId);
                    HashSet<UUID> newMembers = new HashSet<UUID>(members);
                    newMembers.removeAll(existingMembers);
                    String channelId = this.proximityChannels.get(groupId);
                    if (channelId == null || (channel = guild.getVoiceChannelById(channelId)) == null) continue;
                    if (!newMembers.isEmpty()) {
                        UUID memberUuid = (UUID)newMembers.iterator().next();
                        this.addPlayerToChannel(guild, channel, memberUuid);
                        operationDone = true;
                        break;
                    }
                    HashSet<UUID> leftMembers = new HashSet<UUID>(existingMembers);
                    leftMembers.removeAll(members);
                    if (!leftMembers.isEmpty()) {
                        UUID leftUuid = (UUID)leftMembers.iterator().next();
                        this.movePlayerToLobby(guild, lobbyChannel, leftUuid);
                        operationDone = true;
                        break;
                    }
                    this.proximityGroups.put(groupId, members);
                    continue;
                }
                if (operationDone) continue;
                this.createNewProximityGroup(guild, category, groupId, members);
                operationDone = true;
                break;
            }
        }
        this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
            this.proximityChannelLock = false;
        }, 5L);
    }

    private void deleteProximityGroup(Guild guild, VoiceChannel lobbyChannel, String groupId) {
        this.getLogger().info("Deleting proximity group: " + groupId);
        Set<UUID> members = this.proximityGroups.get(groupId);
        String channelId = this.proximityChannels.get(groupId);
        if (members != null && channelId != null) {
            VoiceChannel channel = guild.getVoiceChannelById(channelId);
            if (channel != null) {
                for (UUID memberUuid : new HashSet<UUID>(members)) {
                    String discordId;
                    Member member;
                    if (!this.playerDiscordIds.containsKey(memberUuid) || (member = guild.getMemberById(discordId = this.playerDiscordIds.get(memberUuid))) == null || !member.getVoiceState().inVoiceChannel() || !member.getVoiceState().getChannel().getId().equals(channelId)) continue;
                    try {
                        guild.moveVoiceMember(member, lobbyChannel).queue(success -> member.mute(true).queue(muteSuccess -> this.getLogger().info("Server muted " + member.getUser().getName() + " in lobby"), error -> this.getLogger().warning("Failed to server mute member: " + error.getMessage())), error -> this.getLogger().warning("Failed to move member to lobby: " + error.getMessage()));
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Exception moving member to lobby: " + e.getMessage());
                    }
                }
                this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
                    try {
                        channel.delete().queue(success -> {
                            this.getLogger().info("Deleted disbanded group channel: " + channel.getName());
                            this.proximityGroups.remove(groupId);
                            this.proximityChannels.remove(groupId);
                        }, error -> {
                            this.getLogger().warning("Failed to delete channel: " + error.getMessage());
                            this.proximityGroups.remove(groupId);
                            this.proximityChannels.remove(groupId);
                        });
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Exception deleting channel: " + e.getMessage());
                        this.proximityGroups.remove(groupId);
                        this.proximityChannels.remove(groupId);
                    }
                }, 20L);
            } else {
                this.proximityGroups.remove(groupId);
                this.proximityChannels.remove(groupId);
            }
        } else {
            this.proximityGroups.remove(groupId);
            this.proximityChannels.remove(groupId);
        }
    }

    private void createNewProximityGroup(Guild guild, Category category, String groupId, Set<UUID> members) {
        String uniqueCode = this.generateUniqueCode();
        String channelName = "Prox-" + uniqueCode;
        this.getLogger().info("Creating new proximity group channel: " + channelName);
        try {
            category.createVoiceChannel(channelName).queue(channel -> {
                this.proximityChannels.put(groupId, channel.getId());
                this.proximityGroups.put(groupId, members);
                channel.getManager().putPermissionOverride((IPermissionHolder)guild.getPublicRole(), Arrays.asList(Permission.VOICE_CONNECT), Collections.emptyList()).queue(success -> {
                    Iterator iterator;
                    if (!members.isEmpty() && (iterator = members.iterator()).hasNext()) {
                        UUID firstMemberUuid = (UUID)iterator.next();
                        this.addPlayerToChannel(guild, (VoiceChannel)channel, firstMemberUuid);
                        int delay = 1;
                        while (iterator.hasNext()) {
                            UUID memberUuid = (UUID)iterator.next();
                            int finalDelay = delay++;
                            this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> this.addPlayerToChannel(guild, guild.getVoiceChannelById(channel.getId()), memberUuid), (long)finalDelay * 20L);
                        }
                    }
                }, error -> this.getLogger().warning("Failed to set channel permissions: " + error.getMessage()));
            }, error -> this.getLogger().warning("Failed to create voice channel: " + error.getMessage()));
        }
        catch (Exception e) {
            this.getLogger().warning("Exception creating voice channel: " + e.getMessage());
        }
    }

    private void handleSinglePlayerGroup(Guild guild, VoiceChannel lobbyChannel, VoiceChannel channel, String groupId, Set<UUID> members) {
        String discordId;
        Member member;
        UUID lastMemberUuid = members.iterator().next();
        if (this.playerDiscordIds.containsKey(lastMemberUuid) && (member = guild.getMemberById(discordId = this.playerDiscordIds.get(lastMemberUuid))) != null && member.getVoiceState().inVoiceChannel() && member.getVoiceState().getChannel().getId().equals(channel.getId())) {
            guild.moveVoiceMember(member, lobbyChannel).queue(moveSuccess -> {
                if (member.getVoiceState().getChannel().getId().equals(this.lobbyChannelId)) {
                    member.mute(true).queue(muteSuccess -> this.getLogger().info("Server muted last member " + member.getUser().getName() + " in lobby"), error -> this.getLogger().warning("Failed to server mute last member: " + error.getMessage()));
                }
                channel.delete().queue(deleteSuccess -> {
                    this.getLogger().info("Deleted single-member channel: " + channel.getName());
                    this.proximityGroups.remove(groupId);
                    this.proximityChannels.remove(groupId);
                }, error -> this.getLogger().warning("Failed to delete single-member channel: " + error.getMessage()));
            });
        }
    }

    private void movePlayersToChannel(Guild guild, VoiceChannel channel, Set<UUID> members) {
        for (UUID memberUuid : members) {
            this.addPlayerToChannel(guild, channel, memberUuid);
        }
    }

    private void movePlayerToLobby(Guild guild, VoiceChannel lobbyChannel, UUID playerUuid) {
        if (lobbyChannel == null) {
            this.getLogger().warning("Attempted to move player to null lobby channel");
            return;
        }
        if (this.playerDiscordIds.containsKey(playerUuid)) {
            String discordId = this.playerDiscordIds.get(playerUuid);
            try {
                guild.retrieveMemberById(discordId).queue(member -> {
                    if (member == null) {
                        this.getLogger().warning("Discord member not found: " + discordId);
                        return;
                    }
                    if (member.getVoiceState().inVoiceChannel()) {
                        try {
                            guild.moveVoiceMember((Member)member, lobbyChannel).queue(success -> {
                                if (member.getVoiceState().getChannel().getId().equals(this.lobbyChannelId)) {
                                    member.mute(true).queue(muteSuccess -> this.getLogger().info("Server muted " + member.getUser().getName() + " in lobby"), error -> this.getLogger().warning("Failed to server mute member: " + error.getMessage()));
                                }
                            }, error -> this.getLogger().warning("Failed to move member to lobby: " + error.getMessage()));
                        }
                        catch (Exception e) {
                            this.getLogger().warning("Exception moving member to lobby: " + e.getMessage());
                        }
                    }
                }, error -> this.getLogger().warning("Failed to retrieve Discord member: " + error.getMessage()));
            }
            catch (Exception e) {
                this.getLogger().warning("Exception retrieving Discord member: " + e.getMessage());
            }
        }
    }

    private void addPlayerToChannel(Guild guild, VoiceChannel channel, UUID memberUuid) {
        if (channel == null) {
            this.getLogger().warning("Attempted to add player to null channel");
            return;
        }
        if (this.playerDiscordIds.containsKey(memberUuid)) {
            String discordId = this.playerDiscordIds.get(memberUuid);
            try {
                guild.retrieveMemberById(discordId).queue(member -> {
                    if (member == null) {
                        this.getLogger().warning("Discord member not found: " + discordId);
                        return;
                    }
                    try {
                        VoiceChannel currentChannel = guild.getVoiceChannelById(channel.getId());
                        if (currentChannel == null) {
                            this.getLogger().warning("Channel no longer exists: " + channel.getId());
                            return;
                        }
                        currentChannel.getManager().putPermissionOverride((IPermissionHolder)member, Arrays.asList(Permission.VOICE_SPEAK, Permission.VOICE_USE_VAD), Collections.emptyList()).queue(success -> {
                            try {
                                VoiceChannel finalChannel = guild.getVoiceChannelById(channel.getId());
                                if (finalChannel == null) {
                                    this.getLogger().warning("Channel was deleted before move: " + channel.getId());
                                    return;
                                }
                                if (member.getVoiceState().inVoiceChannel()) {
                                    guild.moveVoiceMember((Member)member, finalChannel).queue(moveSuccess -> member.mute(false).queue(muteSuccess -> this.getLogger().info("Server unmuted " + member.getUser().getName() + " in proximity channel"), error -> this.getLogger().warning("Failed to server unmute member: " + error.getMessage())), error -> this.getLogger().warning("Failed to move member to proximity channel: " + error.getMessage()));
                                } else {
                                    this.getLogger().info("Member " + member.getUser().getName() + " not in a voice channel, can't move");
                                }
                            }
                            catch (Exception e) {
                                this.getLogger().warning("Exception during member move: " + e.getMessage());
                            }
                        }, error -> this.getLogger().warning("Failed to set member permissions: " + error.getMessage()));
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Exception processing channel permissions: " + e.getMessage());
                    }
                }, error -> this.getLogger().warning("Failed to retrieve Discord member: " + error.getMessage()));
            }
            catch (Exception e) {
                this.getLogger().warning("Exception retrieving Discord member: " + e.getMessage());
            }
        }
    }

    private void removePlayerFromGroup(UUID playerUuid, String groupId) {
        Set<UUID> members = this.proximityGroups.get(groupId);
        if (members != null) {
            members.remove(playerUuid);
            Guild guild = this.jda.getGuildById(this.guildId);
            if (guild != null) {
                String discordId;
                Member member;
                String channelId = this.proximityChannels.get(groupId);
                VoiceChannel channel = null;
                if (channelId != null) {
                    channel = guild.getVoiceChannelById(channelId);
                }
                VoiceChannel lobbyChannel = guild.getVoiceChannelById(this.lobbyChannelId);
                if (this.playerDiscordIds.containsKey(playerUuid) && (member = guild.getMemberById(discordId = this.playerDiscordIds.get(playerUuid))) != null && lobbyChannel != null && member.getVoiceState().inVoiceChannel()) {
                    try {
                        guild.moveVoiceMember(member, lobbyChannel).complete();
                        if (member.getVoiceState().getChannel().getId().equals(this.lobbyChannelId)) {
                            member.mute(true).queue(success -> this.getLogger().info("Server muted " + member.getUser().getName() + " in lobby"), error -> this.getLogger().warning("Failed to server mute member: " + error.getMessage()));
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Failed to move player to lobby: " + e.getMessage());
                    }
                }
                if (members.size() <= 1) {
                    String discordId2;
                    Member member2;
                    UUID remainingUuid;
                    if (members.size() == 1 && this.playerDiscordIds.containsKey(remainingUuid = members.iterator().next()) && (member2 = guild.getMemberById(discordId2 = this.playerDiscordIds.get(remainingUuid))) != null && lobbyChannel != null && member2.getVoiceState().inVoiceChannel()) {
                        try {
                            guild.moveVoiceMember(member2, lobbyChannel).complete();
                            if (member2.getVoiceState().getChannel().getId().equals(this.lobbyChannelId)) {
                                member2.mute(true).queue(success -> this.getLogger().info("Server muted last member " + member2.getUser().getName() + " in lobby"), error -> this.getLogger().warning("Failed to server mute last member: " + error.getMessage()));
                            }
                            this.getLogger().info("Moved last player " + discordId2 + " to lobby before deleting channel");
                        }
                        catch (Exception e) {
                            this.getLogger().warning("Failed to move last player to lobby: " + e.getMessage());
                        }
                    }
                    if (channel != null) {
                        try {
                            channel.delete().complete();
                            this.getLogger().info("Deleted voice channel " + channelId + " after player left");
                        }
                        catch (Exception e) {
                            this.getLogger().warning("Failed to delete voice channel: " + e.getMessage());
                        }
                    }
                    this.proximityGroups.remove(groupId);
                    this.proximityChannels.remove(groupId);
                }
            }
        }
    }

    private String generateUniqueCode() {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder code = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 6; ++i) {
            code.append(chars.charAt(random.nextInt(chars.length())));
        }
        return code.toString();
    }

    private void cleanupVoiceChannels() {
        Guild guild = this.jda.getGuildById(this.guildId);
        if (guild == null) {
            return;
        }
        Category category = guild.getCategoryById(this.categoryId);
        if (category == null) {
            return;
        }
        VoiceChannel lobbyChannel = guild.getVoiceChannelById(this.lobbyChannelId);
        if (lobbyChannel == null) {
            return;
        }
        List<VoiceChannel> channels = category.getVoiceChannels();
        for (VoiceChannel channel : channels) {
            if (channel.getId().equals(this.lobbyChannelId)) continue;
            ArrayList<Member> membersToMove = new ArrayList<Member>(channel.getMembers());
            for (Member member : membersToMove) {
                guild.moveVoiceMember(member, lobbyChannel).queue(success -> {
                    if (member.getVoiceState().getChannel().getId().equals(this.lobbyChannelId)) {
                        member.mute(true).queue();
                    }
                }, error -> this.getLogger().warning("Failed to move member during cleanup: " + error.getMessage()));
            }
            if (!membersToMove.isEmpty()) {
                this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> channel.delete().queue(success -> this.getLogger().info("Cleaned up voice channel: " + channel.getName()), error -> this.getLogger().warning("Failed to delete channel during cleanup: " + error.getMessage())), 20L);
                continue;
            }
            channel.delete().queue(success -> this.getLogger().info("Cleaned up voice channel: " + channel.getName()), error -> this.getLogger().warning("Failed to delete channel during cleanup: " + error.getMessage()));
        }
        this.proximityGroups.clear();
        this.proximityChannels.clear();
    }

    public class VoiceChatTestCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            String subCommand;
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7c[VoiceChatZ] \u00a7fThis command can only be used by players!");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("voicechatz.admin")) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fYou don't have permission to use this command!");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fUsage: /voicechattest <check|solo|fix>");
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7f  check - Check if your Discord connection is working");
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7f  solo - Create a solo voice channel for testing");
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7f  fix - Fix lobby permissions (mute users)");
                return true;
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "check": {
                    return this.checkDiscordConnection(player);
                }
                case "solo": {
                    return this.createSoloChannel(player);
                }
                case "fix": {
                    return this.fixLobbyPermissions(player);
                }
            }
            player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fUnknown subcommand. Use: check, solo, or fix");
            return true;
        }

        private boolean checkDiscordConnection(Player player) {
            UUID playerUuid = player.getUniqueId();
            if (!VoiceChatZ.this.playerDiscordIds.containsKey(playerUuid)) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fYou haven't linked your Discord account yet!");
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fUse /linkdiscord <your_discord_id> to link your account.");
                return true;
            }
            String discordId = (String)VoiceChatZ.this.playerDiscordIds.get(playerUuid);
            Guild guild = VoiceChatZ.this.jda.getGuildById(VoiceChatZ.this.guildId);
            if (guild == null) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError: Discord server not found!");
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fServer ID: " + VoiceChatZ.this.guildId);
                return true;
            }
            guild.retrieveMemberById(discordId).queue(member -> {
                if (member == null) {
                    player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError: Your Discord account is linked but you're not in the Discord server!");
                    return;
                }
                player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fDiscord connection check:");
                player.sendMessage("\u00a7a[VoiceChatZ] \u00a7f- Discord account linked: \u00a7aYES");
                player.sendMessage("\u00a7a[VoiceChatZ] \u00a7f- Discord username: \u00a7a" + member.getUser().getName());
                player.sendMessage("\u00a7a[VoiceChatZ] \u00a7f- In voice channel: \u00a7a" + (member.getVoiceState().inVoiceChannel() ? member.getVoiceState().getChannel().getName() : "NO"));
                Category category = guild.getCategoryById(VoiceChatZ.this.categoryId);
                VoiceChannel lobbyChannel = guild.getVoiceChannelById(VoiceChatZ.this.lobbyChannelId);
                player.sendMessage("\u00a7a[VoiceChatZ] \u00a7f- Category exists: \u00a7a" + (category != null ? "YES" : "NO"));
                player.sendMessage("\u00a7a[VoiceChatZ] \u00a7f- Lobby channel exists: \u00a7a" + (lobbyChannel != null ? "YES" : "NO"));
            }, error -> player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError checking Discord connection: " + error.getMessage()));
            return true;
        }

        public boolean createSoloChannel(Player player) {
            UUID playerUuid = player.getUniqueId();
            if (!VoiceChatZ.this.playerDiscordIds.containsKey(playerUuid)) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fYou haven't linked your Discord account yet!");
                return true;
            }
            String discordId = (String)VoiceChatZ.this.playerDiscordIds.get(playerUuid);
            Guild guild = VoiceChatZ.this.jda.getGuildById(VoiceChatZ.this.guildId);
            if (guild == null) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError: Discord server not found!");
                return true;
            }
            Category category = guild.getCategoryById(VoiceChatZ.this.categoryId);
            if (category == null) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError: VoiceChatZ category not found!");
                return true;
            }
            guild.retrieveMemberById(discordId).queue(member -> {
                if (member == null) {
                    player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError: Your Discord account is linked but you're not in the Discord server!");
                    return;
                }
                String uniqueCode = VoiceChatZ.this.generateUniqueCode();
                String channelName = "Test-" + uniqueCode;
                player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fCreating test channel: " + channelName);
                category.createVoiceChannel(channelName).queue(channel -> {
                    channel.getManager().putPermissionOverride((IPermissionHolder)guild.getPublicRole(), Arrays.asList(Permission.VOICE_CONNECT), Collections.emptyList()).putPermissionOverride((IPermissionHolder)member, Arrays.asList(Permission.VOICE_SPEAK, Permission.VOICE_CONNECT), Collections.emptyList()).queue(permSuccess -> {
                        if (member.getVoiceState().inVoiceChannel()) {
                            guild.moveVoiceMember((Member)member, (VoiceChannel)channel).queue(success -> {
                                player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fYou have been moved to the test channel!");
                                member.mute(false).queue(unmuted -> VoiceChatZ.this.getLogger().info("Server unmuted " + member.getUser().getName() + " in test channel"), error -> VoiceChatZ.this.getLogger().warning("Failed to server unmute in test channel: " + error.getMessage()));
                            }, error -> player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError moving you to test channel: " + error.getMessage()));
                        } else {
                            player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fTest channel created! Please join '" + channelName + "' in Discord to test.");
                        }
                    }, permError -> player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError setting channel permissions: " + permError.getMessage()));
                    VoiceChatZ.this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)VoiceChatZ.this, () -> {
                        VoiceChannel lobbyChannel;
                        if (channel.getMembers().size() > 0 && (lobbyChannel = guild.getVoiceChannelById(VoiceChatZ.this.lobbyChannelId)) != null) {
                            ArrayList<Member> membersToMove = new ArrayList<Member>(channel.getMembers());
                            for (Member channelMember : membersToMove) {
                                guild.moveVoiceMember(channelMember, lobbyChannel).queue(moveSuccess -> channelMember.mute(true).queue());
                            }
                        }
                        VoiceChatZ.this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)VoiceChatZ.this, () -> channel.delete().queue(success -> player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fTest channel auto-deleted after 5 minutes."), error -> VoiceChatZ.this.getLogger().warning("Failed to auto-delete test channel: " + error.getMessage())), 20L);
                    }, 6000L);
                }, error -> player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError creating test channel: " + error.getMessage()));
            }, error -> player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError retrieving Discord member: " + error.getMessage()));
            return true;
        }

        private boolean fixLobbyPermissions(Player player) {
            Guild guild = VoiceChatZ.this.jda.getGuildById(VoiceChatZ.this.guildId);
            if (guild == null) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError: Discord server not found!");
                return true;
            }
            VoiceChannel lobbyChannel = guild.getVoiceChannelById(VoiceChatZ.this.lobbyChannelId);
            if (lobbyChannel == null) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError: Lobby channel not found!");
                return true;
            }
            player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fFixing lobby permissions...");
            lobbyChannel.getManager().putPermissionOverride((IPermissionHolder)guild.getPublicRole(), Arrays.asList(Permission.VOICE_CONNECT), Arrays.asList(Permission.VOICE_SPEAK, Permission.VOICE_USE_VAD)).queue(success -> {
                player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fLobby permissions fixed! Users will be server-muted in the lobby now.");
                for (Member member : lobbyChannel.getMembers()) {
                    if (!member.getVoiceState().getChannel().getId().equals(VoiceChatZ.this.lobbyChannelId)) continue;
                    member.mute(true).queue(muteSuccess -> VoiceChatZ.this.getLogger().info("Server muted " + member.getUser().getName() + " in lobby during fix"), error -> VoiceChatZ.this.getLogger().warning("Failed to server mute member during fix: " + error.getMessage()));
                }
            }, error -> player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError fixing lobby permissions: " + error.getMessage()));
            return true;
        }
    }

    public class LinkDiscordCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7c[VoiceChatZ] \u00a7fThis command can only be used by players!");
                return true;
            }
            Player player = (Player)sender;
            if (args.length != 1) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fUsage: /linkdiscord <your_discord_id>");
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fTo get your Discord ID, enable Developer Mode in Discord settings, then right-click your name and select 'Copy ID'");
                return true;
            }
            String discordId = args[0];
            Guild guild = VoiceChatZ.this.jda.getGuildById(VoiceChatZ.this.guildId);
            if (guild == null) {
                player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError: Discord server not found. Please contact an administrator.");
                return true;
            }
            guild.retrieveMemberById(discordId).queue(member -> {
                if (member != null) {
                    VoiceChatZ.this.playerDiscordIds.put(player.getUniqueId(), discordId);
                    player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fYour Discord account has been linked successfully!");
                    player.sendMessage("\u00a7a[VoiceChatZ] \u00a7fJoin the VoiceChatZ-Lobby voice channel in Discord to use proximity voice chat.");
                    VoiceChatZ.this.getConfig().set("player_links." + player.getUniqueId().toString(), (Object)discordId);
                    VoiceChatZ.this.saveConfig();
                } else {
                    player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError: Discord user not found in the server. Make sure you're in the Discord server and the ID is correct.");
                }
            }, error -> player.sendMessage("\u00a7c[VoiceChatZ] \u00a7fError: Invalid Discord ID. Please make sure the ID is correct."));
            return true;
        }
    }

    private class DiscordEventListener
    extends ListenerAdapter {
        private DiscordEventListener() {
        }
    }
}

