/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.commands;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.StringUtilCore;
import de.iani.cubesideutils.commands.AbstractCommandRouter;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.cubesideutils.fabric.commands.CommandExceptionHandler;
import de.iani.cubesideutils.fabric.commands.CommandHandler;
import de.iani.cubesideutils.fabric.commands.SubCommand;
import de.iani.cubesideutils.fabric.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.fabric.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.fabric.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.fabric.commands.exceptions.NoPermissionForPathException;
import de.iani.cubesideutils.fabric.permission.PermissionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class CommandRouter
extends AbstractCommandRouter<SubCommand, FabricClientCommandSource>
implements CommandHandler {
    public static final String UNKNOWN_COMMAND_MESSAGE = "Unknown command. Type \"/help\" for help.";
    private CommandExceptionHandler exceptionHandler;
    private static final Ordering<class_640> ENTRY_ORDERING = Ordering.from((playerListEntry, playerListEntry2) -> {
        class_268 team = playerListEntry.method_2955();
        class_268 team2 = playerListEntry2.method_2955();
        return ComparisonChain.start().compareTrueFirst(playerListEntry.method_2958() != class_1934.field_9219, playerListEntry2.method_2958() != class_1934.field_9219).compare((Comparable)((Object)(team != null ? team.method_1197() : "")), (Comparable)((Object)(team2 != null ? team2.method_1197() : ""))).compare((Object)playerListEntry.method_2966().getName(), (Object)playerListEntry2.method_2966().getName(), String::compareToIgnoreCase).result();
    });

    public CommandRouter() {
        this(true);
    }

    public CommandRouter(boolean caseInsensitive) {
        this(caseInsensitive, CommandExceptionHandler.DEFAULT_HANDLER);
    }

    public CommandRouter(boolean caseInsensitive, CommandExceptionHandler exceptionHandler) {
        super(caseInsensitive);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
    }

    public SubCommand getSubCommand(String path) {
        String[] args = path.split(" ");
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(null, args);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        return nr == args.length ? (SubCommand)currentMap.executor : null;
    }

    @Override
    public List<String> onTabComplete(FabricClientCommandSource sender, String alias, String[] args) {
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(sender, args, 1);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        String partial = args.length > 0 ? args[args.length - 1] : "";
        Collection<String> options = null;
        ArrayList<String> optionsList = null;
        if (currentMap.executor != null) {
            options = Collections.emptyList();
            if (((SubCommand)currentMap.executor).isExecutable(sender)) {
                options = ((SubCommand)currentMap.executor).onTabComplete(sender, alias, new ArgsParser(args, nr));
            }
        } else {
            options = Collections.emptyList();
        }
        if (nr == args.length - 1 && currentMap.subCommands != null) {
            for (Map.Entry<String, AbstractCommandRouter.CommandMap> e : currentMap.subCommands.entrySet()) {
                AbstractCommandRouter.CommandMap subcmd;
                String key = e.getKey();
                if (!StringUtilCore.startsWithIgnoreCase(key, partial) || !this.isAnySubCommandDisplayable(sender, subcmd = e.getValue()) || subcmd.executor != null) continue;
                if (optionsList == null) {
                    optionsList = options == null ? new ArrayList() : new ArrayList<String>(options);
                    options = optionsList;
                }
                optionsList.add(key);
            }
        }
        if (options == null) {
            options = new ArrayList<String>();
            class_634 clientPlayNetworkHandler = sender.getClient().method_1562();
            List list = ENTRY_ORDERING.sortedCopy((Iterable)clientPlayNetworkHandler.method_45732());
            for (class_640 playerListEntry : list) {
                options.add(playerListEntry.method_2966().getName());
            }
        }
        optionsList = StringUtilCore.copyPartialMatches(partial, options);
        Collections.sort(optionsList);
        return optionsList;
    }

    @Override
    public int onCommand(FabricClientCommandSource sender, String alias, String[] args) {
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(sender, args);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        SubCommand toExecute = (SubCommand)currentMap.executor;
        if (toExecute != null) {
            try {
                if (!toExecute.hasRequiredPermission(sender) || !toExecute.isAvailable(sender)) {
                    throw new NoPermissionException(this, sender, alias, toExecute, args, toExecute.getRequiredPermission());
                }
                if (toExecute.onCommand(sender, alias, this.getCommandString(alias, currentMap), new ArgsParser(args, nr))) {
                    return 1;
                }
                throw new IllegalSyntaxException(this, sender, alias, toExecute, args);
            }
            catch (NoPermissionException e) {
                return this.exceptionHandler.handleNoPermission(e);
            }
            catch (IllegalSyntaxException e) {
                return this.exceptionHandler.handleIllegalSyntax(e);
            }
            catch (InternalCommandException e) {
                return this.exceptionHandler.handleInternalException(e);
            }
            catch (Throwable t) {
                return this.exceptionHandler.handleInternalException(new InternalCommandException(this, sender, alias, toExecute, args, t));
            }
        }
        if (!this.isAnySubCommandExecutable(sender, currentMap)) {
            return this.exceptionHandler.handleNoPermissionForPath(new NoPermissionForPathException(this, sender, alias, args));
        }
        this.showHelp(sender, alias, currentMap);
        return 0;
    }

    private String getCommandString(String alias, AbstractCommandRouter.CommandMap currentMap) {
        StringBuilder prefixBuilder = new StringBuilder();
        prefixBuilder.append('/').append(alias).append(' ');
        ArrayList<AbstractCommandRouter.CommandMap> hierarchy = new ArrayList<AbstractCommandRouter.CommandMap>();
        AbstractCommandRouter.CommandMap map = currentMap;
        while (map != null) {
            hierarchy.add(map);
            map = map.parent;
        }
        for (int i = hierarchy.size() - 2; i >= 0; --i) {
            prefixBuilder.append(((AbstractCommandRouter.CommandMap)hierarchy.get((int)i)).name).append(' ');
        }
        return prefixBuilder.toString();
    }

    public void showHelp(FabricClientCommandSource sender, String alias, String[] args) {
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(sender, args);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        this.showHelp(sender, alias, currentMap);
    }

    private void showHelp(FabricClientCommandSource sender, String alias, AbstractCommandRouter.CommandMap currentMap) {
        SubCommand executor;
        if (currentMap.subCommands != null) {
            String prefix = this.getCommandString(alias, currentMap);
            for (AbstractCommandRouter.CommandMap subcmd : currentMap.subcommandsOrdered) {
                String key = subcmd.name;
                if (subcmd.executor == null) {
                    if (!this.isAnySubCommandDisplayable(sender, subcmd)) continue;
                    sender.getPlayer().method_7353((class_2561)class_2561.method_43470((String)(this.exceptionHandler.getHelpMessagePrefix() + prefix + key + " ...")), false);
                    continue;
                }
                if (!((SubCommand)subcmd.executor).hasRequiredPermission(sender) || !((SubCommand)subcmd.executor).isAvailable(sender)) continue;
                sender.getPlayer().method_7353((class_2561)class_2561.method_43470((String)(this.exceptionHandler.getHelpMessagePrefix() + prefix + key + " " + ((SubCommand)subcmd.executor).getUsage(sender))), false);
            }
        }
        if (currentMap.executor != null && (executor = (SubCommand)currentMap.executor).hasRequiredPermission(sender) && executor.isAvailable(sender)) {
            String prefix = this.getCommandString(alias, currentMap);
            sender.getPlayer().method_7353((class_2561)class_2561.method_43470((String)(this.exceptionHandler.getHelpMessagePrefix() + prefix + executor.getUsage(sender))), false);
        }
    }

    private boolean isAnySubCommandExecutable(FabricClientCommandSource sender, AbstractCommandRouter.CommandMap cmd) {
        if (cmd.executor != null && ((SubCommand)cmd.executor).isExecutable(sender)) {
            return true;
        }
        if (cmd.subcommandsOrdered == null) {
            return false;
        }
        if (!this.hasAnyPermission(sender, cmd.requiredPermissions)) {
            return false;
        }
        for (AbstractCommandRouter.CommandMap subcommand : cmd.subcommandsOrdered) {
            if (!this.isAnySubCommandExecutable(sender, subcommand)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnySubCommandDisplayable(FabricClientCommandSource sender, AbstractCommandRouter.CommandMap cmd) {
        if (cmd.executor != null && ((SubCommand)cmd.executor).isDisplayable(sender)) {
            return true;
        }
        if (cmd.subcommandsOrdered == null) {
            return false;
        }
        if (!this.hasAnyPermission(sender, cmd.requiredPermissions)) {
            return false;
        }
        for (AbstractCommandRouter.CommandMap subcommand : cmd.subcommandsOrdered) {
            if (!this.isAnySubCommandDisplayable(sender, subcommand)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyPermission(FabricClientCommandSource sender, Set<String> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return true;
        }
        for (String permission : permissions) {
            if (!PermissionHandler.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkPermission(FabricClientCommandSource sender) {
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(sender, new String[0], 1);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        return this.isAnySubCommandExecutable(sender, currentMap);
    }
}

