/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.commands;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.iani.cubesideutils.fabric.CubesideUtilsFabricClientMod;
import de.iani.cubesideutils.fabric.commands.CommandHandler;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import org.apache.commons.lang3.StringUtils;

public class CommandUtil {
    private CommandUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static void registerCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, String command, CommandHandler handler) {
        Preconditions.checkNotNull((Object)command, (Object)"dispatcher");
        Preconditions.checkNotNull((Object)command, (Object)"command");
        Preconditions.checkNotNull((Object)handler, (Object)"handler");
        CommandAdapter adapter = new CommandAdapter(handler);
        LiteralCommandNode commandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)command).requires((Predicate)adapter)).executes((Command)adapter)).build();
        ArgumentCommandNode defaultArgs = ((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)adapter).executes((Command)adapter)).build();
        Field childrenField = ((Field[])CommandNode.class.getDeclaredFields().clone())[0];
        try {
            childrenField.setAccessible(true);
            Map map = (Map)childrenField.get(dispatcher.getRoot());
            map.remove(command);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        commandNode.addChild((CommandNode)defaultArgs);
        dispatcher.getRoot().addChild((CommandNode)commandNode);
    }

    public static class CommandAdapter
    implements Predicate<FabricClientCommandSource>,
    Command<FabricClientCommandSource>,
    SuggestionProvider<FabricClientCommandSource> {
        private final CommandHandler handler;

        public CommandAdapter(CommandHandler handler) {
            this.handler = handler;
        }

        @Override
        public boolean test(FabricClientCommandSource source) {
            return this.handler.checkPermission(source);
        }

        public int run(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
            String commandLine = context.getRange().get(context.getInput());
            String[] args = StringUtils.split((String)commandLine, (char)' ');
            if (args.length == 0) {
                return 0;
            }
            String label = args[0].toLowerCase(Locale.ENGLISH);
            args = Arrays.copyOfRange(args, 1, args.length);
            try {
                return this.handler.onCommand((FabricClientCommandSource)context.getSource(), label, args);
            }
            catch (Throwable ex) {
                CubesideUtilsFabricClientMod.LOGGER.error("Unhandled exception in command", ex);
                return 0;
            }
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            String commandLine = builder.getInput();
            String[] args = StringUtils.split((String)commandLine, (char)' ');
            if (commandLine.endsWith(" ")) {
                args = Arrays.copyOfRange(args, 0, args.length + 1);
                args[args.length - 1] = "";
            }
            List<Object> results = List.of();
            try {
                if (args.length > 0) {
                    String label = args[0].toLowerCase(Locale.ENGLISH);
                    args = Arrays.copyOfRange(args, 1, args.length);
                    results = this.handler.onTabComplete((FabricClientCommandSource)context.getSource(), label, args);
                }
            }
            catch (Throwable ex) {
                CubesideUtilsFabricClientMod.LOGGER.error("Unhandled exception in tab complete", ex);
            }
            builder = builder.createOffset(builder.getInput().lastIndexOf(32) + 1);
            if (results != null) {
                for (String s : results) {
                    builder.suggest(s);
                }
            }
            return builder.buildFuture();
        }
    }
}

