/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.a;

import de.iani.cubesideutils.fabric.libs.mysql.cj.BindValue;
import de.iani.cubesideutils.fabric.libs.mysql.cj.conf.PropertyKey;
import de.iani.cubesideutils.fabric.libs.mysql.cj.conf.PropertySet;
import de.iani.cubesideutils.fabric.libs.mysql.cj.conf.RuntimeProperty;
import de.iani.cubesideutils.fabric.libs.mysql.cj.exceptions.ExceptionInterceptor;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.Message;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.ServerSession;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.a.AbstractValueEncoder;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.a.NativeConstants;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.a.NativePacketPayload;
import de.iani.cubesideutils.fabric.libs.mysql.cj.util.StringUtils;
import java.nio.charset.StandardCharsets;

public class ByteArrayValueEncoder
extends AbstractValueEncoder {
    protected RuntimeProperty<Integer> maxByteArrayAsHex;

    @Override
    public void init(PropertySet pset, ServerSession serverSess, ExceptionInterceptor excInterceptor) {
        super.init(pset, serverSess, excInterceptor);
        this.maxByteArrayAsHex = pset.getIntegerProperty(PropertyKey.maxByteArrayAsHex);
    }

    @Override
    public byte[] getBytes(BindValue binding) {
        if (binding.escapeBytesIfNeeded()) {
            return this.escapeBytesIfNeeded((byte[])binding.getValue());
        }
        return (byte[])binding.getValue();
    }

    @Override
    public String getString(BindValue binding) {
        if (binding.escapeBytesIfNeeded() && binding.getBinaryLength() <= (long)this.maxByteArrayAsHex.getValue().intValue()) {
            return StringUtils.toString(this.escapeBytesIfNeeded((byte[])binding.getValue()), StandardCharsets.US_ASCII);
        }
        return "** BYTE ARRAY DATA **";
    }

    @Override
    public void encodeAsBinary(Message msg, BindValue binding) {
        ((NativePacketPayload)msg).writeBytes(NativeConstants.StringSelfDataType.STRING_LENENC, (byte[])binding.getValue());
    }
}

