/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi;

import de.iani.cubesideutils.fabric.libs.mysql.cj.MysqlxSession;
import de.iani.cubesideutils.fabric.libs.mysql.cj.exceptions.AssertionFailedException;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.x.StatementExecuteOk;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.x.XMessageBuilder;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.AddResult;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.AddResultBuilder;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.AddResultImpl;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.AddStatement;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.DbDoc;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.JsonParser;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AddStatementImpl
implements AddStatement {
    private MysqlxSession mysqlxSession;
    private String schemaName;
    private String collectionName;
    private List<DbDoc> newDocs;
    private boolean upsert = false;

    AddStatementImpl(MysqlxSession mysqlxSession, String schema, String collection, DbDoc newDoc) {
        this.mysqlxSession = mysqlxSession;
        this.schemaName = schema;
        this.collectionName = collection;
        this.newDocs = new ArrayList<DbDoc>();
        this.newDocs.add(newDoc);
    }

    AddStatementImpl(MysqlxSession mysqlxSession, String schema, String collection, DbDoc[] newDocs) {
        this.mysqlxSession = mysqlxSession;
        this.schemaName = schema;
        this.collectionName = collection;
        this.newDocs = new ArrayList<DbDoc>();
        this.newDocs.addAll(Arrays.asList(newDocs));
    }

    @Override
    public AddStatement add(String jsonString) {
        try {
            DbDoc doc = JsonParser.parseDoc(new StringReader(jsonString));
            return this.add(doc);
        }
        catch (IOException ex) {
            throw AssertionFailedException.shouldNotHappen(ex);
        }
    }

    @Override
    public AddStatement add(DbDoc ... docs) {
        this.newDocs.addAll(Arrays.asList(docs));
        return this;
    }

    private List<String> serializeDocs() {
        return this.newDocs.stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public AddResult execute() {
        if (this.newDocs.size() == 0) {
            StatementExecuteOk ok = new StatementExecuteOk(0L, null, Collections.emptyList(), Collections.emptyList());
            return new AddResultImpl(ok);
        }
        return this.mysqlxSession.query(((XMessageBuilder)this.mysqlxSession.getMessageBuilder()).buildDocInsert(this.schemaName, this.collectionName, this.serializeDocs(), this.upsert), new AddResultBuilder());
    }

    @Override
    public CompletableFuture<AddResult> executeAsync() {
        if (this.newDocs.size() == 0) {
            StatementExecuteOk ok = new StatementExecuteOk(0L, null, Collections.emptyList(), Collections.emptyList());
            return CompletableFuture.completedFuture(new AddResultImpl(ok));
        }
        return this.mysqlxSession.queryAsync(((XMessageBuilder)this.mysqlxSession.getMessageBuilder()).buildDocInsert(this.schemaName, this.collectionName, this.serializeDocs(), this.upsert), new AddResultBuilder());
    }

    @Override
    public boolean isUpsert() {
        return this.upsert;
    }

    @Override
    public AddStatement setUpsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }
}

