/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi;

import de.iani.cubesideutils.fabric.libs.mysql.cj.Messages;
import de.iani.cubesideutils.fabric.libs.mysql.cj.MysqlxSession;
import de.iani.cubesideutils.fabric.libs.mysql.cj.exceptions.AssertionFailedException;
import de.iani.cubesideutils.fabric.libs.mysql.cj.exceptions.FeatureNotAvailableException;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.x.XMessageBuilder;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.x.XProtocolError;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.AddStatement;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.AddStatementImpl;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.Collection;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.CreateIndexParams;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.DatabaseObject;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.DbDoc;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.DbDocImpl;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.DocResult;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.ExprUnparser;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.FindStatement;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.FindStatementImpl;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.JsonParser;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.JsonString;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.JsonValue;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.ModifyStatement;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.ModifyStatementImpl;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.RemoveStatement;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.RemoveStatementImpl;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.Result;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.Schema;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.SchemaImpl;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.Session;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.UpdateResultBuilder;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.XDevAPIError;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;

public class CollectionImpl
implements Collection {
    private MysqlxSession mysqlxSession;
    private XMessageBuilder xbuilder;
    private SchemaImpl schema;
    private String name;

    CollectionImpl(MysqlxSession mysqlxSession, SchemaImpl schema, String name) {
        this.mysqlxSession = mysqlxSession;
        this.schema = schema;
        this.name = name;
        this.xbuilder = (XMessageBuilder)this.mysqlxSession.getMessageBuilder();
    }

    @Override
    public Session getSession() {
        return this.schema.getSession();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatabaseObject.DbObjectStatus existsInDatabase() {
        if (this.mysqlxSession.getDataStoreMetadata().tableExists(this.schema.getName(), this.name)) {
            return DatabaseObject.DbObjectStatus.EXISTS;
        }
        return DatabaseObject.DbObjectStatus.NOT_EXISTS;
    }

    @Override
    public AddStatement add(Map<String, ?> doc) {
        throw new FeatureNotAvailableException("TODO: ");
    }

    @Override
    public AddStatement add(String ... jsonString) {
        try {
            DbDoc[] docs = new DbDoc[jsonString.length];
            for (int i = 0; i < jsonString.length; ++i) {
                docs[i] = JsonParser.parseDoc(new StringReader(jsonString[i]));
            }
            return this.add(docs);
        }
        catch (IOException ex) {
            throw AssertionFailedException.shouldNotHappen(ex);
        }
    }

    @Override
    public AddStatement add(DbDoc doc) {
        return new AddStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, doc);
    }

    @Override
    public AddStatement add(DbDoc ... docs) {
        return new AddStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, docs);
    }

    @Override
    public FindStatement find() {
        return this.find(null);
    }

    @Override
    public FindStatement find(String searchCondition) {
        return new FindStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, searchCondition);
    }

    @Override
    public ModifyStatement modify(String searchCondition) {
        return new ModifyStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, searchCondition);
    }

    @Override
    public RemoveStatement remove(String searchCondition) {
        return new RemoveStatementImpl(this.mysqlxSession, this.schema.getName(), this.name, searchCondition);
    }

    @Override
    public Result createIndex(String indexName, DbDoc indexDefinition) {
        return (Result)this.mysqlxSession.query(this.xbuilder.buildCreateCollectionIndex(this.schema.getName(), this.name, new CreateIndexParams(indexName, indexDefinition)), new UpdateResultBuilder());
    }

    @Override
    public Result createIndex(String indexName, String jsonIndexDefinition) {
        return (Result)this.mysqlxSession.query(this.xbuilder.buildCreateCollectionIndex(this.schema.getName(), this.name, new CreateIndexParams(indexName, jsonIndexDefinition)), new UpdateResultBuilder());
    }

    @Override
    public void dropIndex(String indexName) {
        block2: {
            try {
                this.mysqlxSession.query(this.xbuilder.buildDropCollectionIndex(this.schema.getName(), this.name, indexName), new UpdateResultBuilder());
            }
            catch (XProtocolError e) {
                if (e.getErrorCode() == 1091) break block2;
                throw e;
            }
        }
    }

    @Override
    public long count() {
        try {
            return this.mysqlxSession.getDataStoreMetadata().getTableRowCount(this.schema.getName(), this.name);
        }
        catch (XProtocolError e) {
            if (e.getErrorCode() == 1146) {
                throw new XProtocolError("Collection '" + this.name + "' does not exist in schema '" + this.schema.getName() + "'", e);
            }
            throw e;
        }
    }

    @Override
    public DbDoc newDoc() {
        return new DbDocImpl();
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == CollectionImpl.class && ((CollectionImpl)other).schema.equals(this.schema) && ((CollectionImpl)other).mysqlxSession == this.mysqlxSession && this.name.equals(((CollectionImpl)other).name);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Collection(");
        sb.append(ExprUnparser.quoteIdentifier(this.schema.getName()));
        sb.append(".");
        sb.append(ExprUnparser.quoteIdentifier(this.name));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Result replaceOne(String id, DbDoc doc) {
        if (id == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"id"}));
        }
        if (doc == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"doc"}));
        }
        JsonValue docId = (JsonValue)doc.get("_id");
        if (!(docId == null || JsonString.class.isInstance(docId) && id.equals(((JsonString)docId).getString()))) {
            throw new XDevAPIError(Messages.getString("Collection.DocIdMismatch"));
        }
        return (Result)((ModifyStatement)this.modify("_id = :id").set("$", doc).bind("id", (Object)id)).execute();
    }

    @Override
    public Result replaceOne(String id, String jsonString) {
        if (id == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"id"}));
        }
        if (jsonString == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"jsonString"}));
        }
        try {
            return this.replaceOne(id, JsonParser.parseDoc(new StringReader(jsonString)));
        }
        catch (IOException e) {
            throw AssertionFailedException.shouldNotHappen(e);
        }
    }

    @Override
    public Result addOrReplaceOne(String id, DbDoc doc) {
        if (id == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"id"}));
        }
        if (doc == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"doc"}));
        }
        JsonValue docId = (JsonValue)doc.get("_id");
        if (docId == null) {
            doc.add("_id", new JsonString().setValue(id));
        } else if (!JsonString.class.isInstance(docId) || !id.equals(((JsonString)docId).getString())) {
            throw new XDevAPIError(Messages.getString("Collection.DocIdMismatch"));
        }
        return (Result)this.add(doc).setUpsert(true).execute();
    }

    @Override
    public Result addOrReplaceOne(String id, String jsonString) {
        if (id == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"id"}));
        }
        if (jsonString == null) {
            throw new XDevAPIError(Messages.getString("CreateTableStatement.0", new String[]{"jsonString"}));
        }
        try {
            return this.addOrReplaceOne(id, JsonParser.parseDoc(new StringReader(jsonString)));
        }
        catch (IOException e) {
            throw AssertionFailedException.shouldNotHappen(e);
        }
    }

    @Override
    public DbDoc getOne(String id) {
        return (DbDoc)((DocResult)((FindStatement)this.find("_id = :id").bind("id", (Object)id)).execute()).fetchOne();
    }

    @Override
    public Result removeOne(String id) {
        return (Result)((RemoveStatement)this.remove("_id = :id").bind("id", (Object)id)).execute();
    }
}

