/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi;

import de.iani.cubesideutils.fabric.libs.mysql.cj.Messages;
import de.iani.cubesideutils.fabric.libs.mysql.cj.MysqlxSession;
import de.iani.cubesideutils.fabric.libs.mysql.cj.exceptions.ExceptionFactory;
import de.iani.cubesideutils.fabric.libs.mysql.cj.exceptions.WrongArgumentException;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.x.XMessageBuilder;
import de.iani.cubesideutils.fabric.libs.mysql.cj.protocol.x.XProtocolError;
import de.iani.cubesideutils.fabric.libs.mysql.cj.result.Row;
import de.iani.cubesideutils.fabric.libs.mysql.cj.result.StringValueFactory;
import de.iani.cubesideutils.fabric.libs.mysql.cj.result.ValueFactory;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.Collection;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.CollectionImpl;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.DatabaseObject;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.ExprUnparser;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.Schema;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.Session;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.Table;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.TableImpl;
import de.iani.cubesideutils.fabric.libs.mysql.cj.xdevapi.UpdateResultBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SchemaImpl
implements Schema {
    private MysqlxSession mysqlxSession;
    private XMessageBuilder xbuilder;
    private Session session;
    private String name;
    private ValueFactory<String> svf;

    SchemaImpl(MysqlxSession mysqlxSession, Session session, String name) {
        this.mysqlxSession = mysqlxSession;
        this.session = session;
        this.name = name;
        this.xbuilder = (XMessageBuilder)this.mysqlxSession.getMessageBuilder();
        this.svf = new StringValueFactory(this.mysqlxSession.getPropertySet());
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Schema getSchema() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatabaseObject.DbObjectStatus existsInDatabase() {
        StringBuilder stmt = new StringBuilder("select count(*) from information_schema.schemata where schema_name = '");
        stmt.append(this.name.replaceAll("'", "\\'"));
        stmt.append("'");
        return this.mysqlxSession.getDataStoreMetadata().schemaExists(this.name) ? DatabaseObject.DbObjectStatus.EXISTS : DatabaseObject.DbObjectStatus.NOT_EXISTS;
    }

    @Override
    public List<Collection> getCollections() {
        return this.getCollections(null);
    }

    @Override
    public List<Collection> getCollections(String pattern) {
        Set strTypes = Arrays.stream(new DatabaseObject.DbObjectType[]{DatabaseObject.DbObjectType.COLLECTION}).map(Enum::toString).collect(Collectors.toSet());
        Predicate<Row> rowFiler = r -> strTypes.contains(r.getValue(1, this.svf));
        Function<Row, String> rowToName = r -> r.getValue(0, this.svf);
        List objectNames = this.mysqlxSession.query(this.xbuilder.buildListObjects(this.name, pattern), rowFiler, rowToName, Collectors.toList());
        return objectNames.stream().map(this::getCollection).collect(Collectors.toList());
    }

    @Override
    public List<Table> getTables() {
        return this.getTables(null);
    }

    @Override
    public List<Table> getTables(String pattern) {
        Set strTypes = Arrays.stream(new DatabaseObject.DbObjectType[]{DatabaseObject.DbObjectType.TABLE, DatabaseObject.DbObjectType.VIEW, DatabaseObject.DbObjectType.COLLECTION_VIEW}).map(Enum::toString).collect(Collectors.toSet());
        Predicate<Row> rowFiler = r -> strTypes.contains(r.getValue(1, this.svf));
        Function<Row, String> rowToName = r -> r.getValue(0, this.svf);
        List objectNames = this.mysqlxSession.query(this.xbuilder.buildListObjects(this.name, pattern), rowFiler, rowToName, Collectors.toList());
        return objectNames.stream().map(this::getTable).collect(Collectors.toList());
    }

    @Override
    public Collection getCollection(String collectionName) {
        return new CollectionImpl(this.mysqlxSession, this, collectionName);
    }

    @Override
    public Collection getCollection(String collectionName, boolean requireExists) {
        CollectionImpl coll = new CollectionImpl(this.mysqlxSession, this, collectionName);
        if (requireExists && coll.existsInDatabase() != DatabaseObject.DbObjectStatus.EXISTS) {
            throw new WrongArgumentException(coll.toString() + " doesn't exist");
        }
        return coll;
    }

    @Override
    public Table getCollectionAsTable(String collectionName) {
        return this.getTable(collectionName);
    }

    @Override
    public Table getTable(String tableName) {
        return new TableImpl(this.mysqlxSession, this, tableName);
    }

    @Override
    public Table getTable(String tableName, boolean requireExists) {
        TableImpl table = new TableImpl(this.mysqlxSession, this, tableName);
        if (requireExists && table.existsInDatabase() != DatabaseObject.DbObjectStatus.EXISTS) {
            throw new WrongArgumentException(table.toString() + " doesn't exist");
        }
        return table;
    }

    @Override
    public Collection createCollection(String collectionName) {
        this.mysqlxSession.query(this.xbuilder.buildCreateCollection(this.name, collectionName), new UpdateResultBuilder());
        return new CollectionImpl(this.mysqlxSession, this, collectionName);
    }

    @Override
    public Collection createCollection(String collectionName, boolean reuseExisting) {
        try {
            return this.createCollection(collectionName);
        }
        catch (XProtocolError ex) {
            if (reuseExisting && ex.getErrorCode() == 1050) {
                return this.getCollection(collectionName);
            }
            throw ex;
        }
    }

    @Override
    public Collection createCollection(String collectionName, Schema.CreateCollectionOptions options) {
        try {
            this.mysqlxSession.query(this.xbuilder.buildCreateCollection(this.name, collectionName, options), new UpdateResultBuilder());
            return new CollectionImpl(this.mysqlxSession, this, collectionName);
        }
        catch (XProtocolError ex) {
            if (ex.getErrorCode() == 5015) {
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Schema.CreateCollection"), ex);
            }
            throw ex;
        }
    }

    @Override
    public void modifyCollection(String collectionName, Schema.ModifyCollectionOptions options) {
        try {
            this.mysqlxSession.query(this.xbuilder.buildModifyCollectionOptions(this.name, collectionName, options), new UpdateResultBuilder());
        }
        catch (XProtocolError ex) {
            if (ex.getErrorCode() == 5157) {
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Schema.CreateCollection"), ex);
            }
            throw ex;
        }
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == SchemaImpl.class && ((SchemaImpl)other).session == this.session && ((SchemaImpl)other).mysqlxSession == this.mysqlxSession && this.name.equals(((SchemaImpl)other).name);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Schema(");
        sb.append(ExprUnparser.quoteIdentifier(this.name));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void dropCollection(String collectionName) {
        block2: {
            try {
                this.mysqlxSession.query(this.xbuilder.buildDropCollection(this.name, collectionName), new UpdateResultBuilder());
            }
            catch (XProtocolError e) {
                if (e.getErrorCode() == 1051) break block2;
                throw e;
            }
        }
    }
}

