/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.location;

import com.google.common.base.Preconditions;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.minecraft.class_2338;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class Location {
    private Reference<class_638> level;
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float yaw;

    public Location(@Nullable class_638 level, double x, double y, double z) {
        this(level, x, y, z, 0.0f, 0.0f);
    }

    public Location(@Nullable class_638 level, double x, double y, double z, float yaw, float pitch) {
        if (level != null) {
            this.level = new WeakReference<class_638>(level);
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public class_638 getWorld() {
        if (this.level == null) {
            return null;
        }
        class_638 world = this.level.get();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"level unloaded");
        return world;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return Location.locToBlock(this.x);
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public int getBlockY() {
        return Location.locToBlock(this.y);
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return Location.locToBlock(this.z);
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getPitch() {
        return this.pitch;
    }

    public static float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) >= 180.0f) {
            yaw -= 360.0f;
        } else if (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    public static float normalizePitch(float pitch) {
        if (pitch > 90.0f) {
            pitch = 90.0f;
        } else if (pitch < -90.0f) {
            pitch = -90.0f;
        }
        return pitch;
    }

    public static int locToBlock(double loc) {
        int floor = (int)loc;
        return (double)floor == loc ? floor : floor - (int)(Double.doubleToRawLongBits(loc) >>> 63);
    }

    public class_2338 toBlockPos() {
        return new class_2338(this.getBlockX(), this.getBlockY(), this.getBlockZ());
    }
}

