/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.permission;

import java.util.HashMap;
import java.util.Map;

public class PermissionHandler {
    private static final int PLAYER = 0;
    private static final int VIP = 100;
    private static final int CREATOR = 100;
    private static final int VETERAN = 1500;
    private static final int BUDDY = 2000;
    private static final int STAFF = 5000;
    private static final int ADMIN = 8000;
    private static final int OWNER = 10000;
    private static final Map<String, Integer> RANK_PRIORITIES = Map.of("player", 0, "vip", 100, "creator", 100, "veteran", 1500, "buddy", 2000, "staff", 5000, "admin", 8000, "owner", 10000);
    private static String rank;
    private static Map<String, Integer> minRequiredPermission;

    public PermissionHandler() {
        minRequiredPermission = new HashMap<String, Integer>();
        minRequiredPermission.put("xareomap", 0);
        minRequiredPermission.put("cubeside.addskulltolore", 2000);
        minRequiredPermission.put("cubeside.autochat", 5000);
        minRequiredPermission.put("cubeside.afkcheck", 5000);
    }

    public static boolean hasPermission(String rank, String permission) {
        Integer minPriority;
        if (rank == null) {
            return false;
        }
        Integer rankPriority = RANK_PRIORITIES.get(rank.toLowerCase());
        if (rankPriority == null) {
            rankPriority = 0;
        }
        return (minPriority = minRequiredPermission.get(permission.toLowerCase())) != null && rankPriority >= minPriority;
    }

    public String getRank() {
        return rank;
    }

    public static void setRank(String setrank) {
        rank = setrank;
    }

    public static boolean hasPermission(String permission) {
        return PermissionHandler.hasPermission(rank, permission);
    }

    static {
        minRequiredPermission = null;
    }
}

