/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.profilefetcher;

import com.google.common.base.Preconditions;
import de.iani.cubesideutils.fabric.profilefetcher.ProfileProperty;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;

public class CachedPlayerProfile {
    private final UUID uuid;
    private final Set<ProfileProperty> properties;
    private final int propteriesHashCode;
    private final long lastSeen;
    private final long cacheLoadTime;

    public CachedPlayerProfile(UUID uuid, Set<ProfileProperty> properties, long lastSeen, long cacheLoadTime) {
        Preconditions.checkNotNull((Object)uuid);
        this.uuid = uuid;
        this.properties = Collections.unmodifiableSet(new LinkedHashSet<ProfileProperty>(properties));
        this.propteriesHashCode = properties.hashCode();
        this.lastSeen = lastSeen;
        this.cacheLoadTime = cacheLoadTime;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    long getCacheLoadTime() {
        return this.cacheLoadTime;
    }

    public int hashCode() {
        return this.uuid.hashCode() + this.propteriesHashCode + (int)this.lastSeen;
    }

    public Set<ProfileProperty> getProperties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != CachedPlayerProfile.class) {
            return false;
        }
        CachedPlayerProfile other = (CachedPlayerProfile)obj;
        return this.uuid.equals(other.uuid) && this.properties.equals(other.properties) && this.lastSeen == other.lastSeen;
    }
}

