/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.profilefetcher;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileProperty {
    private final String name;
    private final String value;
    private final String signature;

    public ProfileProperty(@NotNull String name, @NotNull String value) {
        this(name, value, null);
    }

    public ProfileProperty(@NotNull String name, @NotNull String value, @Nullable String signature) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"ProfileProperty name can not be null");
        this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"ProfileProperty value can not be null");
        this.signature = signature;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getSignature() {
        return this.signature;
    }

    public boolean isSigned() {
        return this.signature != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileProperty that = (ProfileProperty)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

