/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.scheduler;

import java.util.concurrent.Executor;

public class ScheduledTask
implements Comparable<ScheduledTask> {
    private Runnable task;
    private volatile boolean cancelled;
    private long nextExecutionTick;
    private int delay;
    private int intervall;
    private Executor executor;

    public ScheduledTask(Runnable task, int delay, int intervall, Executor executor) {
        this.task = task;
        this.delay = delay;
        this.intervall = intervall;
        this.executor = executor;
    }

    public void cancel() {
        this.cancelled = true;
        this.task = null;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    void execute() {
        Runnable task = this.task;
        if (!this.isCancelled() && task != null) {
            if (this.executor != null) {
                this.executor.execute(task);
            } else {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public int getDelay() {
        return this.delay;
    }

    void setScheduledOnTick(long scheduledOnTick, boolean forFirstExecution) {
        this.nextExecutionTick = forFirstExecution ? scheduledOnTick + (long)this.delay : scheduledOnTick + (long)this.intervall;
    }

    long getScheduledOnTick() {
        return this.nextExecutionTick;
    }

    public int getIntervall() {
        return this.intervall;
    }

    long getExecutionTick() {
        return this.nextExecutionTick;
    }

    @Override
    public int compareTo(ScheduledTask o) {
        return Long.signum(this.nextExecutionTick - o.nextExecutionTick);
    }
}

