/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.scheduler;

import de.iani.cubesideutils.fabric.scheduler.ScheduledTask;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class Scheduler {
    private Thread ownerThread;
    private ConcurrentLinkedQueue<ScheduledTask> queueFromAsync;
    private PriorityQueue<ScheduledTask> timedTasks;
    private ArrayDeque<ScheduledTask> immediateTasks;
    private ArrayList<ScheduledTask> everyTickTasks;
    private long currentTick;
    private final Executor defaultExecutor = Executors.newCachedThreadPool();
    static final Scheduler INSTANCE = new Scheduler();

    private Scheduler() {
        this.queueFromAsync = new ConcurrentLinkedQueue();
        this.timedTasks = new PriorityQueue();
        this.immediateTasks = new ArrayDeque();
        this.everyTickTasks = new ArrayList();
    }

    public static ScheduledTask scheduleSyncRepeatingTask(Runnable task, int delay, int inverval) {
        return INSTANCE.scheduleTaskInternal(task, delay, inverval, null);
    }

    public static ScheduledTask scheduleSyncTask(Runnable task, int delay) {
        return INSTANCE.scheduleTaskInternal(task, delay, -1, null);
    }

    public static ScheduledTask scheduleImmediateSyncTask(Runnable task) {
        return INSTANCE.scheduleTaskInternal(task, 0, -1, null);
    }

    public static ScheduledTask scheduleImmediateAsynchronousTask(Runnable task) {
        return INSTANCE.scheduleTaskInternal(task, 0, -1, Scheduler.INSTANCE.defaultExecutor);
    }

    public static ScheduledTask scheduleAsynchronousTask(Runnable task, int delay) {
        return INSTANCE.scheduleTaskInternal(task, delay, -1, Scheduler.INSTANCE.defaultExecutor);
    }

    public static ScheduledTask scheduleAsynchronousRepeatingTask(Runnable task, int delay, int interval) {
        return INSTANCE.scheduleTaskInternal(task, delay, interval, Scheduler.INSTANCE.defaultExecutor);
    }

    public static ScheduledTask scheduleImmediateAsynchronousTask(Runnable task, Executor executor) {
        return INSTANCE.scheduleTaskInternal(task, 0, -1, executor == null ? Scheduler.INSTANCE.defaultExecutor : executor);
    }

    public static ScheduledTask scheduleAsynchronousTask(Runnable task, int delay, Executor executor) {
        return INSTANCE.scheduleTaskInternal(task, delay, -1, executor == null ? Scheduler.INSTANCE.defaultExecutor : executor);
    }

    public static ScheduledTask scheduleAsynchronousRepeatingTask(Runnable task, int delay, int interval, Executor executor) {
        return INSTANCE.scheduleTaskInternal(task, delay, interval, executor == null ? Scheduler.INSTANCE.defaultExecutor : executor);
    }

    private ScheduledTask scheduleTaskInternal(Runnable task, int delay, int inverval, Executor executor) {
        if (inverval < 1) {
            inverval = -1;
        }
        if (delay < 0) {
            delay = 0;
        }
        return this.schedule(new ScheduledTask(task, delay, inverval, executor));
    }

    private ScheduledTask schedule(ScheduledTask scheduledTask) {
        if (this.ownerThread == Thread.currentThread()) {
            if (scheduledTask.getDelay() <= 0) {
                this.immediateTasks.addLast(scheduledTask);
            } else {
                this.timedTasks.add(scheduledTask);
            }
            scheduledTask.setScheduledOnTick(this.currentTick, true);
        } else {
            this.queueFromAsync.add(scheduledTask);
        }
        return scheduledTask;
    }

    void processOnTick() {
        ScheduledTask scheduledTask = this.queueFromAsync.poll();
        while (scheduledTask != null) {
            if (scheduledTask.getDelay() <= 0) {
                this.immediateTasks.addLast(scheduledTask);
            } else {
                this.timedTasks.add(scheduledTask);
            }
            scheduledTask.setScheduledOnTick(this.currentTick, true);
            scheduledTask = this.queueFromAsync.poll();
        }
        int everyTickTasksSize = this.everyTickTasks.size();
        for (int i = 0; i < everyTickTasksSize; ++i) {
            scheduledTask = this.everyTickTasks.get(i);
            scheduledTask.execute();
            if (!scheduledTask.isCancelled()) continue;
            this.everyTickTasks.remove(i);
            --i;
            --everyTickTasksSize;
        }
        scheduledTask = this.immediateTasks.pollFirst();
        while (scheduledTask != null) {
            scheduledTask.execute();
            if (scheduledTask.getIntervall() > 0 && !scheduledTask.isCancelled()) {
                if (scheduledTask.getIntervall() == 1) {
                    this.everyTickTasks.add(scheduledTask);
                } else {
                    scheduledTask.setScheduledOnTick(this.currentTick, false);
                    this.timedTasks.add(scheduledTask);
                }
            }
            scheduledTask = this.immediateTasks.pollFirst();
        }
        scheduledTask = this.timedTasks.peek();
        while (scheduledTask != null && scheduledTask.getExecutionTick() <= this.currentTick) {
            this.timedTasks.poll();
            scheduledTask.execute();
            if (scheduledTask.getIntervall() > 0 && !scheduledTask.isCancelled()) {
                if (scheduledTask.getIntervall() == 1) {
                    this.everyTickTasks.add(scheduledTask);
                } else {
                    scheduledTask.setScheduledOnTick(this.currentTick, false);
                    this.timedTasks.add(scheduledTask);
                }
            }
            scheduledTask = this.immediateTasks.peek();
        }
        ++this.currentTick;
    }

    void initialize(Thread serverThread) {
        this.ownerThread = serverThread;
    }
}

