/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.fabric.scheduler;

import de.iani.cubesideutils.fabric.scheduler.ScheduledTask;
import de.iani.cubesideutils.fabric.scheduler.Scheduler;
import java.util.concurrent.Executor;

public abstract class TaskRunnable {
    private ScheduledTask task;

    public abstract void run();

    public final TaskRunnable scheduleSyncRepeating(int delay, int inverval) {
        this.checkNotScheduled();
        this.task = Scheduler.scheduleSyncRepeatingTask(this::run, delay, inverval);
        return this;
    }

    public final TaskRunnable scheduleSync(int delay) {
        this.checkNotScheduled();
        this.task = Scheduler.scheduleSyncTask(this::run, delay);
        return this;
    }

    public final TaskRunnable scheduleImmediateSync() {
        this.checkNotScheduled();
        this.task = Scheduler.scheduleImmediateSyncTask(this::run);
        return this;
    }

    public final TaskRunnable scheduleAsynchronousRepeating(int delay, int inverval) {
        this.checkNotScheduled();
        this.task = Scheduler.scheduleAsynchronousRepeatingTask(this::run, delay, inverval);
        return this;
    }

    public final TaskRunnable scheduleAsynchronous(int delay) {
        this.checkNotScheduled();
        this.task = Scheduler.scheduleAsynchronousTask(this::run, delay);
        return this;
    }

    public final TaskRunnable scheduleImmediateAsynchronous() {
        this.checkNotScheduled();
        this.task = Scheduler.scheduleImmediateAsynchronousTask(this::run);
        return this;
    }

    public final TaskRunnable scheduleAsynchronousRepeating(int delay, int inverval, Executor executor) {
        this.checkNotScheduled();
        this.task = Scheduler.scheduleAsynchronousRepeatingTask(this::run, delay, inverval, executor);
        return this;
    }

    public final TaskRunnable scheduleAsynchronous(int delay, Executor executor) {
        this.checkNotScheduled();
        this.task = Scheduler.scheduleAsynchronousTask(this::run, delay, executor);
        return this;
    }

    public final TaskRunnable scheduleImmediateAsynchronous(Executor executor) {
        this.checkNotScheduled();
        this.task = Scheduler.scheduleImmediateAsynchronousTask(this::run, executor);
        return this;
    }

    public final void cancel() {
        this.checkScheduled();
        this.task.cancel();
    }

    private void checkNotScheduled() {
        if (this.task != null) {
            throw new IllegalStateException("This task is already scheduled");
        }
    }

    private void checkScheduled() {
        if (this.task == null) {
            throw new IllegalStateException("This task is not scheduled");
        }
    }
}

