/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.nbt.io;

import de.iani.cubesideutils.nbt.BaseTag;
import de.iani.cubesideutils.nbt.ByteArrayTag;
import de.iani.cubesideutils.nbt.ByteTag;
import de.iani.cubesideutils.nbt.CompoundTag;
import de.iani.cubesideutils.nbt.DoubleTag;
import de.iani.cubesideutils.nbt.FloatTag;
import de.iani.cubesideutils.nbt.IntArrayTag;
import de.iani.cubesideutils.nbt.IntTag;
import de.iani.cubesideutils.nbt.ListTag;
import de.iani.cubesideutils.nbt.LongArrayTag;
import de.iani.cubesideutils.nbt.LongTag;
import de.iani.cubesideutils.nbt.ShortTag;
import de.iani.cubesideutils.nbt.StringTag;
import de.iani.cubesideutils.nbt.TagType;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NbtInputStream
extends DataInputStream {
    public NbtInputStream(InputStream in) {
        super(in);
    }

    public CompoundTag readNbt() throws IOException {
        TagType type = TagType.valueOf(this.readByte());
        if (type != TagType.COMPOUND) {
            new IOException("Root tag must be a named compound tag");
        }
        CompoundTag root = new CompoundTag();
        this.readUTF();
        this.load(root);
        return root;
    }

    private void load(BaseTag<?> tag) throws IOException {
        switch (tag.getType()) {
            case BYTE: {
                ((ByteTag)tag).setData(this.readByte());
                break;
            }
            case SHORT: {
                ((ShortTag)tag).setData(this.readShort());
                break;
            }
            case INT: {
                ((IntTag)tag).setData(this.readInt());
                break;
            }
            case LONG: {
                ((LongTag)tag).setData(this.readLong());
                break;
            }
            case FLOAT: {
                ((FloatTag)tag).setData(this.readFloat());
                break;
            }
            case DOUBLE: {
                ((DoubleTag)tag).setData(this.readDouble());
                break;
            }
            case BYTE_ARRAY: {
                int length = this.readInt();
                byte[] data = new byte[length];
                this.readFully(data);
                ((ByteArrayTag)tag).setData(data);
                break;
            }
            case STRING: {
                ((StringTag)tag).setData(this.readUTF());
                break;
            }
            case LIST: {
                ListTag list = (ListTag)tag;
                list.clear();
                TagType type = TagType.valueOf(this.readByte());
                list.setElementType(type);
                int size = this.readInt();
                for (int i = 0; i < size; ++i) {
                    BaseTag subtag = type.create();
                    this.load(subtag);
                    list.add(subtag);
                }
                break;
            }
            case COMPOUND: {
                TagType type;
                CompoundTag compound = (CompoundTag)tag;
                compound.clear();
                while ((type = TagType.valueOf(this.readByte())) != TagType.END) {
                    String name = this.readUTF();
                    BaseTag subtag = type.create();
                    this.load(subtag);
                    compound.put(name, subtag);
                }
                break;
            }
            case INT_ARRAY: {
                int length = this.readInt();
                int[] data = new int[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = this.readInt();
                }
                ((IntArrayTag)tag).setData(data);
                break;
            }
            case LONG_ARRAY: {
                int length = this.readInt();
                long[] data = new long[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = this.readLong();
                }
                ((LongArrayTag)tag).setData(data);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag type: " + String.valueOf((Object)tag.getType()));
            }
        }
    }
}

