data modify entity @s Items set from storage minions:zprivate menu_design
playsound ui.button.click master @p[tag=Minion.InMenu] ~ ~ ~

scoreboard players operation #Search Minion.ID = @s Minion.ID
clear @a[tag=Minion.Listening] *[custom_data={menu_item:1b}]

# --------------------------------------------------------------------------------- #

# Get base minion cooldown in seconds
data modify storage minions:zprivate string set from entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{name:"cooldown"}].value

# convert cooldown string to int
scoreboard players set #Value Minion.Calc 0
function minion:handler/calc/str_to_int
scoreboard players operation #Cooldown Minion.Calc = #Value Minion.Calc

# Get the cooldown reduction value
scoreboard players set #CooldownReduction Minion.Calc 100

function minion:handler/menu/set_items/get_upgrade_module

execute as @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] at @s if entity @e[distance=..5, type=item_display, tag=Minion.ExternalBuff] run scoreboard players remove #CooldownReduction Minion.Calc 3

scoreboard players operation #Cooldown Minion.Calc *= #CooldownReduction Minion.Calc
scoreboard players operation #Cooldown Minion.Calc /= $100 Minion.Calc

# Get the cooldown minutes value
scoreboard players reset #CooldownMinutes Minion.Calc

execute if score #Cooldown Minion.Calc matches 60.. run scoreboard players operation #CooldownMinutes Minion.Calc = #Cooldown Minion.Calc
execute if score #Cooldown Minion.Calc matches 60.. run scoreboard players operation #CooldownMinutes Minion.Calc /= $60 Minion.Calc

# Get the cooldown seconds value
scoreboard players operation #CooldownSeconds Minion.Calc = #Cooldown Minion.Calc
scoreboard players operation #CooldownSeconds Minion.Calc %= $60 Minion.Calc

function minion:handler/menu/set_items/format_time

# --------------------------------------------------------------------------------- #

# Get the base storage values
data modify storage minions:zprivate string set from entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{name:"storage"}].value

scoreboard players set #Value Minion.Calc 0
function minion:handler/calc/str_to_int
scoreboard players operation #Storage Minion.Calc = #Value Minion.Calc

# Get the max storage value
data modify storage minions:zprivate string set from entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{name:"storage"}].signature

scoreboard players set #Value Minion.Calc 0
function minion:handler/calc/str_to_int
scoreboard players operation #MaxStorage Minion.Calc = #Value Minion.Calc

# Get the max storage upgrade value
scoreboard players set #StorageExpansion Minion.Calc 0

function minion:handler/menu/set_items/get_storage_upgrade

scoreboard players operation #MaxStorage Minion.Calc += #StorageExpansion Minion.Calc


# Check for special minions with a max storage cap
execute if score #MaxStorage Minion.Calc matches 101.. if data entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{name:"type", value:"lava"}] run scoreboard players set #MaxStorage Minion.Calc 100

# --------------------------------------------------------------------------------- #

# Set the Minion Upgrade Module item
execute if data entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{"name":"upgrade_module", "value":""}] run loot replace entity @s container.10 loot minion:menu/upgrade_module

execute if data entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{"name":"upgrade_module", "value":"Control Node"}] run data modify entity @s Items append value {Slot:10, id: "amethyst_shard", count: 1, components: {"minecraft:lore": [{text:"Enhance your minion's efficiency", color: "gray",italic: false},{text:"by installing an upgrade module.", color: "gray",italic: false},"",{color:"gray",italic:false,text:"Current Upgrade Module:"},{color:"yellow",italic:false,text:"> Control Node <"},"",{color:"aqua",italic:false,text:"Enhances your minion's speed"},{color:"aqua",italic:false,text:"by 5%."},"",{color:"gray",italic:false,text:"Click to remove module."}], "minecraft:max_stack_size": 1, "minecraft:custom_name": {color:"green",italic:false,text:"Upgrade Module"}, "minecraft:custom_data": {menu_item: 1b}}}

execute if data entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{"name":"upgrade_module", "value":"Stabilization Unit"}] run data modify entity @s Items append value {Slot:10, id: "breeze_rod", count: 1, components: {"minecraft:lore": [{text:"Enhance your minion's efficiency", color: "gray",italic: false},{text:"by installing an upgrade module.", color: "gray",italic: false},"",{color:"gray",italic:false,text:"Current Upgrade Module:"},{color:"yellow",italic:false,text:"> Stabilization Unit <"},"",{color:"aqua",italic:false,text:"Enhances your minion's speed"},{color:"aqua",italic:false,text:"by 7%."},"",{color:"gray",italic:false,text:"Click to remove module."}], "minecraft:max_stack_size": 1, "minecraft:custom_name": {color:"green",italic:false,text:"Upgrade Module"}, "minecraft:custom_data": {menu_item: 1b}}}

execute if data entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{"name":"upgrade_module", "value":"Thermal Regulation Unit"}] run data modify entity @s Items append value {Slot:10, id: "blaze_powder", count: 1, components: {"minecraft:lore": [{text:"Enhance your minion's efficiency", color: "gray",italic: false},{text:"by installing an upgrade module.", color: "gray",italic: false},"",{color:"gray",italic:false,text:"Current Upgrade Module:"},{color:"yellow",italic:false,text:"> Thermal Regulation Unit <"},"",{color:"aqua",italic:false,text:"Enhances your minion's speed"},{color:"aqua",italic:false,text:"by 10%."},"",{color:"gray",italic:false,text:"Click to remove module."}], "minecraft:max_stack_size": 1, "minecraft:custom_name": {color:"green",italic:false,text:"Upgrade Module"}, "minecraft:custom_data": {menu_item: 1b}}}

execute if data entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{"name":"upgrade_module", "value":"Energy Redistribution Core"}] run data modify entity @s Items append value {Slot:10, id: "nether_star", count: 1, components: {"minecraft:lore": [{text:"Enhance your minion's efficiency", color: "gray",italic: false},{text:"by installing an upgrade module.", color: "gray",italic: false},"",{color:"gray",italic:false,text:"Current Upgrade Module:"},{color:"yellow",italic:false,text:"> Energy Redistribution Core <"},"",{color:"aqua",italic:false,text:"Enhances your minion's speed"},{color:"aqua",italic:false,text:"by 15%."},"",{color:"gray",italic:false,text:"Click to remove module."}], "minecraft:max_stack_size": 1, "minecraft:custom_name": {color:"green",italic:false,text:"Upgrade Module"}, "minecraft:custom_data": {menu_item: 1b}}}

# --------------------------------------------------------------------------------- #

# Set the Minion Upgrade to next tier item
data modify storage minions:zprivate string set from entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{name:"tier"}].value

scoreboard players set #Value Minion.Calc 0
function minion:handler/calc/str_to_int

scoreboard players operation #NextTier Minion.Calc = #Value Minion.Calc
scoreboard players add #NextTier Minion.Calc 1

execute if score #NextTier Minion.Calc matches 2 run scoreboard players set #NextTierCosts Minion.Calc 16
execute if score #NextTier Minion.Calc matches 3 run scoreboard players set #NextTierCosts Minion.Calc 32
execute if score #NextTier Minion.Calc matches 4 run scoreboard players set #NextTierCosts Minion.Calc 64
execute if score #NextTier Minion.Calc matches 5 run scoreboard players set #NextTierCosts Minion.Calc 128

execute if score #Value Minion.Calc matches 1..4 run loot replace entity @s container.11 loot minion:menu/upgrade_minion
execute if score #Value Minion.Calc matches 5 run loot replace entity @s container.11 loot minion:menu/max_tier

# --------------------------------------------------------------------------------- #

# Set the Minion Information item
function minion:handler/macro/block_check with entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{"name":"resource"}]

# Set the Minion Items item
execute if entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1, tag=!Minion.CannotWork] run function minion:handler/calc/get_timestamp

loot replace entity @s container.15 loot minion:menu/minion_items

# --------------------------------------------------------------------------------- #

# Set the Minion Storage item
execute if data entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{name:"storage_upgrade", value:""}] run loot replace entity @s container.16 loot minion:menu/upgrade_storage

execute if data entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{name:"storage_upgrade", value:"Storage Capacity Disk"}] run data modify entity @s Items append value {Slot:16, id: "gray_dye", count: 1, components: {"minecraft:lore": [{color:"gray",italic:false,text:"Upgrade your minion storage to be"},{color:"gray",italic:false,text:"able to store more items at once."},"",{color:"gray",italic:false,text:"Current Storage Upgrade:"},{color:"light_purple",italic:false,text:"> Storage Capacity Disk <"},"",{color:"aqua",italic:false,text:"Upgrades your minion storage"},{color:"aqua",italic:false,text:"with 16 more items at once."},"",{color:"gray",italic:false,text:"Click to remove storage expansion."}], "minecraft:custom_name": {color:"green",italic:false,text:"Storage Upgrade"}, "minecraft:custom_data": {menu_item: 1b}}}

execute if data entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{name:"storage_upgrade", value:"Data Capacity Expander"}] run data modify entity @s Items append value {Slot:16, id: "lime_dye", count: 1, components: {"minecraft:lore": [{color:"gray",italic:false,text:"Upgrade your minion storage to be"},{color:"gray",italic:false,text:"able to store more items at once."},"",{color:"gray",italic:false,text:"Current Storage Upgrade:"},{color:"light_purple",italic:false,text:"> Data Capacity Expander <"},"",{color:"aqua",italic:false,text:"Upgrades your minion storage"},{color:"aqua",italic:false,text:"with 32 more items at once."},"",{color:"gray",italic:false,text:"Click to remove storage expansion."}], "minecraft:custom_name": {color:"green",italic:false,text:"Storage Upgrade"}, "minecraft:custom_data": {menu_item: 1b}}}

execute if data entity @e[distance=..6, type=armor_stand, tag=Minion, predicate=minion:same_minion_id, limit=1] equipment.head.components."minecraft:profile".properties[{name:"storage_upgrade", value:"Chip Expansion Board"}] run data modify entity @s Items append value {Slot:16, id: "light_blue_dye", count: 1, components: {"minecraft:lore": [{color:"gray",italic:false,text:"Upgrade your minion storage to be"},{color:"gray",italic:false,text:"able to store more items at once."},"",{color:"gray",italic:false,text:"Current Storage Upgrade:"},{color:"light_purple",italic:false,text:"> Chip Expansion Board <"},"",{color:"aqua",italic:false,text:"Upgrades your minion storage"},{color:"aqua",italic:false,text:"with 64 more items at once."},"",{color:"gray",italic:false,text:"Click to remove storage expansion."}], "minecraft:custom_name": {color:"green",italic:false,text:"Storage Upgrade"}, "minecraft:custom_data": {menu_item: 1b}}}