/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui;

import com.mafuyu404.oneenoughitem.api.DomainRegistry;
import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.components.ItemGridWidget;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.util.ReplacementControl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public abstract class BaseObjectSelectionScreen<T>
extends Screen {
    protected static final int ITEMS_PER_PAGE = 45;
    protected static final int GRID_WIDTH = 9;
    protected static final int GRID_HEIGHT = 5;
    protected final ReplacementEditorScreen parent;
    protected final boolean isForMatch;
    protected EditBox searchBox;
    protected Button sortButton;
    protected Button prevPageButton;
    protected Button nextPageButton;
    protected Button backButton;
    protected ItemGridWidget itemGrid;
    protected List<T> allObjects;
    protected List<T> filteredObjects;
    protected int currentPage = 0;
    protected final Set<String> selectedIds = new HashSet<String>();
    protected Button confirmSelectionButton;
    protected Button clearSelectionButton;
    protected SortMode sortMode = SortMode.NAME;
    private int lastSearchLength = 0;

    protected BaseObjectSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch, Component title) {
        super(title);
        this.parent = parent;
        this.isForMatch = isForMatch;
        this.allObjects = new ArrayList<T>();
        this.filteredObjects = new ArrayList<T>();
        this.updateGrid();
    }

    protected abstract Component sortLabel();

    protected abstract List<T> loadAllObjects();

    protected abstract String getId(T var1);

    protected abstract void renderObject(T var1, GuiGraphics var2, int var3, int var4);

    protected abstract void onSelectSingle(String var1);

    protected abstract boolean isSelectable(String var1, boolean var2);

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        this.searchBox = new EditBox(this.f_96547_, centerX - 80, 15, 160, 18, (Component)Component.m_237115_((String)"gui.oneenoughitem.search"));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.sortButton = GuiUtils.createButton(this.getSortLabel(this.sortMode), btn -> this.onSort(), centerX + 90, 15, 70, 18);
        this.m_142416_((GuiEventListener)this.sortButton);
        int gridStartX = centerX - 81;
        int gridStartY = 45;
        this.itemGrid = new ItemGridWidget(gridStartX, gridStartY, 9, 5, this::handleGridItemClick);
        this.m_142416_((GuiEventListener)this.itemGrid);
        int buttonY = gridStartY + 90 + 10;
        this.prevPageButton = GuiUtils.createButton((Component)Component.m_237113_((String)"<"), btn -> this.previousPage(), centerX - 80, buttonY, 25, 18);
        this.m_142416_((GuiEventListener)this.prevPageButton);
        this.nextPageButton = GuiUtils.createButton((Component)Component.m_237113_((String)">"), btn -> this.nextPage(), centerX + 55, buttonY, 25, 18);
        this.m_142416_((GuiEventListener)this.nextPageButton);
        this.backButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.back"), btn -> this.m_7379_(), centerX - 40, buttonY, 80, 18);
        this.m_142416_((GuiEventListener)this.backButton);
        if (this.isForMatch) {
            this.confirmSelectionButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.add_selected"), btn -> this.confirmSelected(), centerX - 120, buttonY + 25, 100, 18);
            this.m_142416_((GuiEventListener)this.confirmSelectionButton);
            this.clearSelectionButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.clear_selected"), btn -> {
                this.selectedIds.clear();
                this.updateGrid();
                this.updateConfirmButtonsVisibility();
            }, centerX + 20, buttonY + 25, 100, 18);
            this.m_142416_((GuiEventListener)this.clearSelectionButton);
        }
        this.allObjects = this.loadAllObjects();
        this.filteredObjects = new ArrayList<T>(this.allObjects);
        this.applySort();
        this.updateGrid();
        this.updateNavigationButtons();
        this.updateConfirmButtonsVisibility();
    }

    protected Component getSortLabel(SortMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case SortMode.NAME -> Component.m_237115_((String)"gui.oneenoughitem.sort.name");
            case SortMode.MOD -> Component.m_237115_((String)"gui.oneenoughitem.sort.mod");
            case SortMode.ID -> Component.m_237115_((String)"gui.oneenoughitem.sort.id");
        };
    }

    protected Comparator<T> getComparator(SortMode mode) {
        return (a, b) -> 0;
    }

    protected void onSort() {
        this.sortMode = switch (this.sortMode) {
            default -> throw new IncompatibleClassChangeError();
            case SortMode.NAME -> SortMode.MOD;
            case SortMode.MOD -> SortMode.ID;
            case SortMode.ID -> SortMode.NAME;
        };
        this.applySort();
        this.updateGrid();
        this.updateNavigationButtons();
        this.sortButton.m_93666_(this.getSortLabel(this.sortMode));
    }

    protected void applySort() {
        Comparator<T> cmp = this.getComparator(this.sortMode);
        if (cmp != null) {
            this.filteredObjects = new ArrayList<T>(this.filteredObjects);
            this.filteredObjects.sort(cmp);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.searchBox.m_94155_().length() != this.getLastSearchLength()) {
            this.filterObjects();
            this.currentPage = 0;
            this.updateGrid();
            this.updateNavigationButtons();
        }
    }

    private int getLastSearchLength() {
        int current = this.lastSearchLength;
        this.lastSearchLength = this.searchBox.m_94155_().length();
        return current;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        int totalPages = (this.filteredObjects.size() + 45 - 1) / 45;
        String pageInfo = this.currentPage + 1 + " / " + Math.max(1, totalPages);
        int buttonY = 145;
        graphics.m_280137_(this.f_96547_, pageInfo, this.f_96543_ / 2, buttonY + 25, 0xFFFFFF);
        String count = this.filteredObjects.size() + " entries";
        graphics.m_280488_(this.f_96547_, count, 10, buttonY + 35, 0xFFFFFF);
    }

    protected void filterObjects() {
        String search = this.searchBox.m_94155_().toLowerCase();
        this.filteredObjects = search.isEmpty() ? new ArrayList<T>(this.allObjects) : this.allObjects.stream().filter(obj -> {
            String id = Optional.ofNullable(this.getId(obj)).orElse("").toLowerCase();
            return id.contains(search);
        }).toList();
    }

    protected void updateGrid() {
    }

    protected void updateNavigationButtons() {
        int totalPages = (this.filteredObjects.size() + 45 - 1) / 45;
        this.prevPageButton.f_93623_ = this.currentPage > 0;
        this.nextPageButton.f_93623_ = this.currentPage < totalPages - 1;
    }

    protected void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.updateGrid();
            this.updateNavigationButtons();
        }
    }

    protected void nextPage() {
        int totalPages = (this.filteredObjects.size() + 45 - 1) / 45;
        if (this.currentPage < totalPages - 1) {
            ++this.currentPage;
            this.updateGrid();
            this.updateNavigationButtons();
        }
    }

    protected void confirmSelected() {
        if (!this.isForMatch || this.selectedIds.isEmpty()) {
            return;
        }
        int added = 0;
        for (String id : new ArrayList<String>(this.selectedIds)) {
            if (!this.isSelectable(id, true)) continue;
            this.onSelectSingle(id);
            ++added;
        }
        this.selectedIds.clear();
        this.updateGrid();
        this.updateConfirmButtonsVisibility();
        this.m_7379_();
    }

    protected void updateConfirmButtonsVisibility() {
        boolean hasSelection;
        if (!this.isForMatch) {
            return;
        }
        boolean bl = hasSelection = !this.selectedIds.isEmpty();
        if (this.confirmSelectionButton != null) {
            this.confirmSelectionButton.f_93623_ = hasSelection;
        }
        if (this.clearSelectionButton != null) {
            this.clearSelectionButton.f_93623_ = hasSelection;
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    private void handleGridItemClick(ItemStack stack) {
        String id = ReplacementControl.withSkipReplacement(() -> DomainRegistry.current().dataIdFromItem(stack.m_41720_()));
        if (id == null) {
            return;
        }
        if (this.isForMatch && BaseObjectSelectionScreen.m_96637_()) {
            if (this.selectedIds.contains(id)) {
                this.selectedIds.remove(id);
            } else {
                this.selectedIds.add(id);
            }
            this.updateGrid();
            this.updateConfirmButtonsVisibility();
            return;
        }
        if (!this.isSelectable(id, this.isForMatch)) {
            return;
        }
        this.onSelectSingle(id);
        this.m_7379_();
    }

    protected static enum SortMode {
        NAME,
        MOD,
        ID;

    }
}

